/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.twitter;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.pluginapi.event.EventPoller;
import twitter4j.Status;
import twitter4j.Tweet;

public class TwitterEventPoller
implements EventPoller {
    private final List<Event> events = new Vector<Event>();
    private String eventType;

    public TwitterEventPoller(String eventType) {
        this.eventType = eventType;
    }

    public String getEventType() {
        return this.eventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Event> poll() {
        HashSet<Event> eventSet = new HashSet<Event>();
        List<Event> list = this.events;
        synchronized (list) {
            eventSet.addAll(this.events);
            this.events.clear();
        }
        return eventSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatuses(List<Status> statuses) {
        List<Event> list = this.events;
        synchronized (list) {
            for (Status status : statuses) {
                Event ev = new Event(this.getEventType(), status.getUser().getName(), status.getCreatedAt().getTime(), EventSeverity.INFO, status.getText());
                this.events.add(ev);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTweets(List<Tweet> tweets) {
        List<Event> list = this.events;
        synchronized (list) {
            for (Tweet tweet : tweets) {
                Event ev = new Event(this.getEventType(), tweet.getFromUser(), tweet.getCreatedAt().getTime(), EventSeverity.INFO, tweet.getText());
                this.events.add(ev);
            }
        }
    }
}

