/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.packagetypeCli;

import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.PackageVersionFormatDescription;
import org.rhq.core.domain.content.ValidatablePackageDetailsKey;
import org.rhq.core.domain.util.OSGiVersion;
import org.rhq.core.domain.util.OSGiVersionComparator;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.content.AbstractPackageTypeBehavior;
import org.rhq.enterprise.server.plugin.pc.content.PackageDetailsValidationException;

public class CliPackageTypeBehavior
extends AbstractPackageTypeBehavior<ServerPluginComponent> {
    private static final Log LOG = LogFactory.getLog(CliPackageTypeBehavior.class);
    private static final String FULL_VERSION_REGEX = "^([^:]+:)?\\d+(\\.\\d+(\\.\\d+(\\..*)?)?)?$";
    private static final String OSGI_EXTRACT_REGEX = "^([^:]+:)?(\\d+(\\.\\d+(\\.\\d+(\\..*)?)?)?)$";
    private static final int OSGI_EXTRACT_VERSION_GROUP = 2;
    private static final String PACKAGETYPE_NAME = "org.rhq.enterprise.server.plugins.packagetypeCli.SERVER_SIDE_CLI_SCRIPT";
    private static final Comparator<PackageVersion> VERSION_COMPARATOR = new Comparator<PackageVersion>(){
        private final OSGiVersionComparator OSGI_COMPARATOR = new OSGiVersionComparator();

        @Override
        public int compare(PackageVersion o1, PackageVersion o2) {
            String v1 = o1.getVersion();
            String v2 = o2.getVersion();
            if (v1 != null && v2 != null) {
                String[] v1Parts = CliPackageTypeBehavior.getVersionParts(v1);
                String[] v2Parts = CliPackageTypeBehavior.getVersionParts(v2);
                if (v1Parts[1] != null && v2Parts[1] != null) {
                    try {
                        return this.OSGI_COMPARATOR.compare(v1Parts[1], v2Parts[1]);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
            }
            LOG.warn((Object)("Using a fallback version comparison on package versions " + o1 + " and " + o2 + ". This should not happen."));
            return Integer.valueOf(o1.getId()).compareTo(o2.getId());
        }
    };

    public Comparator<PackageVersion> getPackageVersionComparator(String packageTypeName) {
        if (PACKAGETYPE_NAME.equals(packageTypeName)) {
            return VERSION_COMPARATOR;
        }
        return null;
    }

    public void validateDetails(ValidatablePackageDetailsKey key, Subject origin) throws PackageDetailsValidationException {
        key.setVersion(CliPackageTypeBehavior.reformatVersion(key.getVersion(), origin.getName()));
    }

    public PackageVersionFormatDescription getPackageVersionFormat(String packageTypeName) {
        if (PACKAGETYPE_NAME.equals(packageTypeName)) {
            return new PackageVersionFormatDescription(FULL_VERSION_REGEX, OSGI_EXTRACT_REGEX, 2, null);
        }
        return null;
    }

    private static String reformatVersion(String version, String userName) throws PackageDetailsValidationException {
        String[] parts = CliPackageTypeBehavior.getVersionParts(version);
        if (!OSGiVersion.isValid((String)parts[1])) {
            throw new PackageDetailsValidationException("The version part of '" + version + "' isn't an OSGi version string.");
        }
        return userName + ":" + parts[1];
    }

    private static String[] getVersionParts(String version) {
        String[] ret = new String[2];
        int colonIdx = version.indexOf(58);
        if (colonIdx >= 0 && colonIdx < version.length() - 1) {
            ret[0] = version.substring(0, colonIdx);
            ret[1] = version.substring(colonIdx + 1);
        } else {
            ret[1] = version;
        }
        return ret;
    }
}

