/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertOperations;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.plugins.alertOperations.Token;
import org.rhq.enterprise.server.plugins.alertOperations.TokenClass;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class AlertTokenReplacer {
    private final Log log = LogFactory.getLog(AlertTokenReplacer.class);
    public static final String NOT_YET_IMPLEMENTED = " - not yet implemented -";
    protected static final String THE_QUICK_BROWN_FOX_JUMPS_OVER_THE_LAZY_DOG = "TheQuickBrownFoxJumpsOverTheLazyDOg";
    private Alert alert;
    private Pattern pattern;
    private OperationDefinition operationDefinition;
    private Resource targetResource;

    public AlertTokenReplacer(Alert alert, OperationDefinition operationDefinition, Resource targetResource) {
        this.alert = alert;
        this.operationDefinition = operationDefinition;
        this.targetResource = targetResource;
        this.pattern = Pattern.compile("<%\\s*([a-zA-Z]+\\.[a-zA-Z0-9]+)\\s*%>");
    }

    public String replaceTokens(String input) {
        String work = input;
        Matcher matcher = this.pattern.matcher(work);
        if (!matcher.find()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No tokens found in " + input));
            }
            return input;
        }
        matcher.reset();
        while ((matcher = this.pattern.matcher(work)).find()) {
            String s;
            String replacement = this.replaceToken(matcher.group(1));
            work = s = matcher.replaceFirst(replacement);
        }
        return work;
    }

    public String replaceToken(String tokenString) {
        if (!tokenString.contains(".")) {
            return tokenString;
        }
        String tmp = tokenString.substring(0, tokenString.indexOf("."));
        TokenClass tc = TokenClass.getByText(tmp);
        if (tc == null) {
            this.log.warn((Object)("Unknown token class in [" + tokenString + "], not replacing tokens"));
            return tokenString;
        }
        Token token = Token.getByText(tokenString);
        if (token == null) {
            this.log.warn((Object)("No known token found in [" + tokenString + "], not replacing token"));
            return tokenString;
        }
        String ret = null;
        block0 : switch (tc) {
            case ALERT: {
                ret = this.replaceAlertToken(token, this.alert);
                break;
            }
            case RESOURCE: {
                ret = this.replaceResourceToken(token, this.alert.getAlertDefinition().getResource());
                break;
            }
            case TARGET_RESOURCE: {
                String text = "resource." + token.getName();
                Token tok = Token.getByText(text);
                ret = this.replaceResourceToken(tok, this.targetResource);
                break;
            }
            case OPERATION: {
                ret = this.replaceOperationToken(token);
                break;
            }
            case TEST: {
                switch (token) {
                    case TEST_ECHO: {
                        ret = tokenString;
                        break block0;
                    }
                    case TEST_FIX: {
                        ret = THE_QUICK_BROWN_FOX_JUMPS_OVER_THE_LAZY_DOG;
                        break block0;
                    }
                    case TEST_CAMEL: {
                        ret = "camel";
                        break block0;
                    }
                }
                ret = NOT_YET_IMPLEMENTED;
            }
        }
        return ret;
    }

    private String replaceAlertToken(Token token, Alert alert) {
        AlertManagerLocal mgr = LookupUtil.getAlertManager();
        switch (token) {
            case ALERT_ID: {
                return String.valueOf(alert.getId());
            }
            case ALERT_FIRE_TIME: {
                return new Date(alert.getCtime()).toString();
            }
            case ALERT_WILL_RECOVER: {
                return String.valueOf(alert.getAlertDefinition().getWillRecover());
            }
            case ALERT_WILL_DISABLE: {
                return String.valueOf(mgr.willDefinitionBeDisabled(alert));
            }
            case ALERT_DEF_NAME: {
                return alert.getAlertDefinition().getName();
            }
            case ALERT_DEF_DESC: {
                return alert.getAlertDefinition().getDescription();
            }
            case ALERT_DEF_PRIO: {
                return alert.getAlertDefinition().getPriority().getName();
            }
            case ALERT_URL: {
                return mgr.prettyPrintAlertURL(alert);
            }
            case ALERT_CONDITIONS: {
                return mgr.prettyPrintAlertConditions(alert, false);
            }
        }
        return NOT_YET_IMPLEMENTED;
    }

    private String replaceResourceToken(Token token, Resource resource) {
        Subject overlord;
        ResourceManagerLocal mgr = LookupUtil.getResourceManager();
        Resource platform = mgr.getPlaformOfResource(overlord = LookupUtil.getSubjectManager().getOverlord(), resource.getId());
        if (platform == null) {
            platform = resource;
        }
        switch (token) {
            case RESOURCE_ID: {
                return String.valueOf(resource.getId());
            }
            case RESOURCE_NAME: {
                return resource.getName();
            }
            case RESOURCE_PARENT_ID: {
                Resource parent = mgr.getParentResource(resource.getId());
                if (parent == null) {
                    return "0";
                }
                return String.valueOf(parent.getId());
            }
            case RESOURCE_PARENT_NAME: {
                Resource parent = mgr.getParentResource(resource.getId());
                if (parent == null) {
                    return "N/A";
                }
                return parent.getName();
            }
            case RESOURCE_TYPE_ID: {
                return String.valueOf(resource.getResourceType().getId());
            }
            case RESOURCE_TYPE_NAME: {
                return resource.getResourceType().getName();
            }
            case RESOURCE_PLATFORM_ID: {
                return String.valueOf(platform.getId());
            }
            case RESOURCE_PLATFORM_NAME: {
                return platform.getName();
            }
            case RESOURCE_PLATFORM_TYPE: {
                return platform.getResourceType().getName();
            }
        }
        return NOT_YET_IMPLEMENTED;
    }

    private String replaceOperationToken(Token token) {
        switch (token) {
            case OPERATION_ID: {
                return String.valueOf(this.operationDefinition.getId());
            }
            case OPERATION_NAME: {
                return this.operationDefinition.getName();
            }
        }
        return NOT_YET_IMPLEMENTED;
    }
}

