/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertEmail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.util.LookupUtil;

public class EmailSender
extends AlertSender {
    public SenderResult send(Alert alert) {
        String emailAddressString = this.alertParameters.getSimpleValue("emailAddress", null);
        if (emailAddressString == null) {
            return SenderResult.getSimpleFailure((String)"No email address given");
        }
        List emails = AlertSender.unfence((String)emailAddressString, String.class, (String)",");
        try {
            HashSet uniqueEmails = new HashSet(emails);
            Collection badEmails = LookupUtil.getAlertManager().sendAlertNotificationEmails(alert, uniqueEmails);
            ArrayList goodEmails = new ArrayList(uniqueEmails);
            goodEmails.removeAll(badEmails);
            SenderResult result = new SenderResult();
            result.setSummary("Target addresses were: " + uniqueEmails);
            if (goodEmails.size() > 0) {
                result.addSuccessMessage("Successfully sent to: " + goodEmails);
            }
            if (badEmails.size() > 0) {
                result.addFailureMessage("Failed to send to: " + badEmails);
            }
            return result;
        }
        catch (Throwable t) {
            return SenderResult.getSimpleFailure((String)("Error sending email notifications to " + emails + ", cause: " + t.getMessage()));
        }
    }

    public String previewConfiguration() {
        String emailAddressString = this.alertParameters.getSimpleValue("emailAddress", null);
        if (emailAddressString == null || emailAddressString.trim().length() == 0) {
            return "<empty>";
        }
        return emailAddressString;
    }
}

