/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.database.DatabasePluginUtil;
import org.rhq.plugins.mysql.MySqlComponent;

public class MySqlDatabaseDiscoveryComponent
implements ResourceDiscoveryComponent<MySqlComponent> {
    private static final Log LOG = LogFactory.getLog(MySqlDatabaseDiscoveryComponent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<MySqlComponent> context) {
        LinkedHashSet<DiscoveredResourceDetails> linkedHashSet;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Database discovery started");
        }
        Connection jdbcConnection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            jdbcConnection = ((MySqlComponent)context.getParentResourceComponent()).getPooledConnectionProvider().getPooledConnection();
            statement = jdbcConnection.createStatement();
            resultSet = statement.executeQuery("SHOW DATABASES");
            LinkedHashSet<DiscoveredResourceDetails> databases = new LinkedHashSet<DiscoveredResourceDetails>();
            while (resultSet.next()) {
                String databaseName = resultSet.getString(1);
                Configuration config = context.getDefaultPluginConfiguration();
                config.put((Property)new PropertySimple("databaseName", (Object)databaseName));
                DiscoveredResourceDetails details = new DiscoveredResourceDetails(context.getResourceType(), databaseName, databaseName + " Database", null, "A MySql Database", config, null);
                databases.add(details);
            }
            linkedHashSet = databases;
        }
        catch (SQLException ignore) {
            Set<DiscoveredResourceDetails> set;
            try {
                set = Collections.emptySet();
            }
            catch (Throwable throwable) {
                DatabasePluginUtil.safeClose((Connection)jdbcConnection, statement, resultSet);
                throw throwable;
            }
            DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, resultSet);
            return set;
        }
        DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
        return linkedHashSet;
    }
}

