/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.database.DatabasePluginUtil;

public class MySqlDiscoveryComponent
implements ResourceDiscoveryComponent,
ManualAddFacet {
    private static final Log LOG = LogFactory.getLog(MySqlDiscoveryComponent.class);
    public static final String HOST_CONFIGURATION_PROPERTY = "host";
    public static final String PORT_CONFIGURATION_PROPERTY = "port";
    public static final String DB_CONFIGURATION_PROPERTY = "db";
    public static final String PRINCIPAL_CONFIGURATION_PROPERTY = "principal";
    public static final String CREDENTIALS_CONFIGURATION_PROPERTY = "credentials";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Resource Discovery Started");
        }
        LinkedHashSet<DiscoveredResourceDetails> servers = new LinkedHashSet<DiscoveredResourceDetails>();
        List autoDiscoveryResults = context.getAutoDiscoveredProcesses();
        for (ProcessScanResult result : autoDiscoveryResults) {
            LOG.info((Object)("Discovered a mysql process: " + result));
            ProcessInfo procInfo = result.getProcessInfo();
            servers.add(MySqlDiscoveryComponent.createResourceDetails(context, context.getDefaultPluginConfiguration(), procInfo));
        }
        return servers;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfiguration, ResourceDiscoveryContext resourceDiscoveryContext) throws InvalidPluginConfigurationException {
        ProcessInfo processInfo = null;
        DiscoveredResourceDetails resourceDetails = MySqlDiscoveryComponent.createResourceDetails(resourceDiscoveryContext, pluginConfiguration, processInfo);
        return resourceDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DiscoveredResourceDetails createResourceDetails(ResourceDiscoveryContext discoveryContext, Configuration pluginConfig, ProcessInfo processInfo) throws InvalidPluginConfigurationException {
        Connection conn = null;
        String version = "";
        try {
            conn = MySqlDiscoveryComponent.buildConnection(pluginConfig);
            version = conn.getMetaData().getDatabaseProductVersion();
        }
        catch (SQLException ex) {
        }
        finally {
            DatabasePluginUtil.safeClose((Connection)conn);
        }
        String key = "MySql:" + pluginConfig.getSimple(DB_CONFIGURATION_PROPERTY).getStringValue() + ":" + pluginConfig.getSimple(HOST_CONFIGURATION_PROPERTY).getStringValue() + ":" + pluginConfig.getSimple(PORT_CONFIGURATION_PROPERTY).getStringValue() + "-" + pluginConfig.getSimple(PRINCIPAL_CONFIGURATION_PROPERTY).getStringValue();
        String name = "MySql [" + pluginConfig.getSimple(DB_CONFIGURATION_PROPERTY).getStringValue() + "]";
        DiscoveredResourceDetails result = new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, name, version, "MySql Server", pluginConfig, processInfo);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Discovered Database Server for MySQL Database " + MySqlDiscoveryComponent.buildConnectionURL(pluginConfig)));
        }
        return result;
    }

    static String buildConnectionURL(Configuration pluginConfig) {
        return "jdbc:mysql://" + pluginConfig.getSimple(HOST_CONFIGURATION_PROPERTY).getStringValue() + ":" + pluginConfig.getSimple(PORT_CONFIGURATION_PROPERTY).getStringValue() + "/" + pluginConfig.getSimple(DB_CONFIGURATION_PROPERTY).getStringValue();
    }

    static Connection buildConnection(Configuration pluginConfig) throws SQLException {
        String driverClass = "com.mysql.jdbc.Driver";
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidPluginConfigurationException("Specified JDBC driver class (" + driverClass + ") not found.");
        }
        String url = MySqlDiscoveryComponent.buildConnectionURL(pluginConfig);
        String principal = pluginConfig.getSimple(PRINCIPAL_CONFIGURATION_PROPERTY).getStringValue();
        String credentials = pluginConfig.getSimple(CREDENTIALS_CONFIGURATION_PROPERTY).getStringValue();
        return DriverManager.getConnection(url, principal, credentials);
    }
}

