/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.database.DatabasePluginUtil;
import org.rhq.plugins.mysql.MySqlDatabaseComponent;

public class MySqlTableDiscoveryComponent
implements ResourceDiscoveryComponent {
    private static final Log LOG = LogFactory.getLog(MySqlTableDiscoveryComponent.class);
    private static final String TABLE_DISCOVERY = "tableDiscovery";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set discoverResources(ResourceDiscoveryContext rdc) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> set = new HashSet<DiscoveredResourceDetails>();
        MySqlDatabaseComponent parent = (MySqlDatabaseComponent)rdc.getParentResourceComponent();
        Configuration pconfig = rdc.getParentResourceContext().getPluginConfiguration();
        if (!Boolean.parseBoolean(pconfig.getSimpleValue(TABLE_DISCOVERY, "true"))) {
            LOG.debug((Object)"table discovery disabled");
            return set;
        }
        Connection jdbcConnection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            jdbcConnection = parent.getPooledConnectionProvider().getPooledConnection();
            statement = jdbcConnection.createStatement();
            resultSet = statement.executeQuery("show tables from " + parent.getName());
            while (resultSet.next()) {
                String tableName = resultSet.getString(1);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Discovered Table " + tableName));
                }
                Configuration config = new Configuration();
                config.put((Property)new PropertySimple("tableName", (Object)tableName));
                DiscoveredResourceDetails details = new DiscoveredResourceDetails(rdc.getResourceType(), tableName, tableName + " Table", null, tableName + " MySql Table", config, null);
                set.add(details);
            }
        }
        catch (SQLException se) {
            block7: {
                try {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug((Object)"Unable to Discover Tables", (Throwable)se);
                }
                catch (Throwable throwable) {
                    DatabasePluginUtil.safeClose((Connection)jdbcConnection, statement, resultSet);
                    throw throwable;
                }
            }
            DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, resultSet);
        }
        DatabasePluginUtil.safeClose((Connection)jdbcConnection, (Statement)statement, (ResultSet)resultSet);
        return set;
    }
}

