/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas;

import java.io.File;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jbossas.AbstractMessagingComponent;
import org.rhq.plugins.jbossas.JBossASServerComponent;
import org.rhq.plugins.jbossas.util.DeploymentUtility;
import org.rhq.plugins.jbossas.util.FileNameUtility;
import org.rhq.plugins.jbossas.util.JBossMBeanUtility;
import org.rhq.plugins.jbossas.util.JMSConfigurationEditor;

public class JMSComponent
extends AbstractMessagingComponent
implements ConfigurationFacet,
DeleteResourceFacet {
    public static final String TOPIC_MBEAN_NAME = "jboss.mq.destination:service=Topic";
    public static final String QUEUE_MBEAN_NAME = "jboss.mq.destination:service=Queue";
    private static final Log LOG = LogFactory.getLog(JMSComponent.class);

    public AvailabilityType getAvailability() {
        return JBossMBeanUtility.isStarted(this.getEmsBean(), this.getResourceContext()) ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        super.getValues(report, requests, "jboss.mq:service=");
    }

    public void start(ResourceContext<JBossASServerComponent<?>> context) {
        super.start(context, new JMSConfigurationEditor(context.getResourceType().getName()));
    }

    public CreateResourceReport createResource(CreateResourceReport report) {
        String objectNamePreString;
        JBossASServerComponent parentResourceComponent = (JBossASServerComponent)this.getResourceContext().getParentResourceComponent();
        String resourceTypeName = report.getResourceType().getName();
        boolean isTopic = false;
        if (resourceTypeName.contains("Topic")) {
            objectNamePreString = TOPIC_MBEAN_NAME;
            isTopic = true;
        } else {
            objectNamePreString = QUEUE_MBEAN_NAME;
        }
        Configuration config = report.getResourceConfiguration();
        String name = config.getSimple("MBeanName").getStringValue();
        PropertySimple nameTemplateProp = report.getPluginConfiguration().getSimple("nameTemplate");
        String rName = nameTemplateProp.getStringValue();
        rName = rName.replace("{name}", name);
        EmsConnection connection = parentResourceComponent.getEmsConnection();
        if (DeploymentUtility.isDuplicateJndiName(connection, objectNamePreString, name)) {
            report.setStatus(CreateResourceStatus.FAILURE);
            report.setErrorMessage("Duplicate JNDI Name, a resource with that name already exists");
            return report;
        }
        PropertySimple pluginNameProperty = new PropertySimple("name", (Object)rName);
        this.getResourceContext().getPluginConfiguration().put((Property)pluginNameProperty);
        File deployDir = new File(parentResourceComponent.getConfigurationPath() + "/deploy");
        File deploymentFile = new File(deployDir, FileNameUtility.formatFileName(name) + "-jms-service.xml");
        this.xmlEditor = new JMSConfigurationEditor(resourceTypeName);
        this.xmlEditor.updateConfiguration(deploymentFile, name, report);
        try {
            parentResourceComponent.deployFile(deploymentFile);
        }
        catch (Exception e) {
            JBossASServerComponent.setErrorOnCreateResourceReport(report, e.getLocalizedMessage(), e);
            return report;
        }
        String serviceString = isTopic ? "Topic" : "Queue";
        String objectName = "jboss.mq.destination:name=" + name + ",service=" + serviceString;
        try {
            objectName = this.getCanonicalName(objectName);
            report.setResourceKey(objectName);
        }
        catch (MalformedObjectNameException e) {
            log.warn((Object)("Invalid key [" + objectName + "]: " + e.getMessage()));
            return report;
        }
        report.setResourceName(rName);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            log.info((Object)"Sleep after datasource create interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return report;
    }
}

