/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.database.ConnectionPoolingSupport;
import org.rhq.plugins.database.CustomTableRowDiscoveryComponent;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabasePluginUtil;
import org.rhq.plugins.database.PooledConnectionProvider;

public class CustomTableComponent
implements DatabaseComponent<DatabaseComponent<?>>,
ConnectionPoolingSupport,
MeasurementFacet {
    private static final Log LOG = LogFactory.getLog(CustomTableComponent.class);
    private ResourceContext<DatabaseComponent<?>> context;
    private PooledConnectionProvider pooledConnectionProvider;

    public void start(ResourceContext<DatabaseComponent<?>> resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.context = resourceContext;
        if (DatabasePluginUtil.hasConnectionPoolingSupport(this.context.getParentResourceComponent())) {
            this.pooledConnectionProvider = ((ConnectionPoolingSupport)this.context.getParentResourceComponent()).getPooledConnectionProvider();
        }
    }

    public void stop() {
        this.pooledConnectionProvider = null;
    }

    @Override
    public boolean supportsConnectionPooling() {
        return this.pooledConnectionProvider != null;
    }

    @Override
    public PooledConnectionProvider getPooledConnectionProvider() {
        return this.pooledConnectionProvider;
    }

    public String getTable() {
        return this.context.getPluginConfiguration().getSimpleValue("table", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        AvailabilityType availabilityType;
        block7: {
            if (this.getTable().isEmpty()) {
                return AvailabilityType.UP;
            }
            Statement statement = null;
            Connection connection = null;
            ResultSet resultSet = null;
            try {
                connection = DatabasePluginUtil.getConnectionFromComponent(this);
                statement = connection.createStatement();
                statement.setMaxRows(1);
                statement.setFetchSize(1);
                resultSet = statement.executeQuery("SELECT * FROM " + this.getTable());
                availabilityType = AvailabilityType.UP;
                DatabasePluginUtil.safeClose(null, statement, resultSet);
                if (!this.supportsConnectionPooling()) break block7;
            }
            catch (SQLException e) {
                AvailabilityType availabilityType2 = AvailabilityType.DOWN;
                return availabilityType2;
            }
            finally {
                DatabasePluginUtil.safeClose(null, statement, resultSet);
                if (this.supportsConnectionPooling()) {
                    DatabasePluginUtil.safeClose(connection, statement, resultSet);
                }
            }
            DatabasePluginUtil.safeClose(connection, statement, resultSet);
        }
        return availabilityType;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        Configuration config = this.context.getPluginConfiguration();
        String query = config.getSimpleValue("metricQuery", null);
        if (query == null) {
            if (LOG.isTraceEnabled()) {
                ResourceType type = this.context.getResourceType();
                String resourceKey = this.context.getResourceKey();
                LOG.trace((Object)("Resource " + resourceKey + " (" + type.getName() + ", plugin " + type.getPlugin() + "): The plugin configuration doesn't specify 'metricQuery' property. Ignoring the measurement request."));
            }
            return;
        }
        query = CustomTableRowDiscoveryComponent.formatMessage(query, config.getSimpleValue("key", null));
        String column = config.getSimpleValue("column", "");
        Map<String, Double> values = Boolean.parseBoolean(column) ? DatabasePluginUtil.getNumericQueryValues(this, query, new Object[0]) : DatabasePluginUtil.getNumericQueryValueMap(this, query, new Object[0]);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("returned values " + values));
        }
        for (MeasurementScheduleRequest request : metrics) {
            String columnName = request.getName();
            Double value = values.get(columnName);
            if (value == null && (value = values.get(columnName.toLowerCase())) == null) {
                value = values.get(columnName.toUpperCase());
            }
            if (value != null) {
                report.addData(new MeasurementDataNumeric(request, value));
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Missing column in query results - metric not collected: " + columnName));
        }
    }

    @Override
    public Connection getConnection() {
        return ((DatabaseComponent)this.context.getParentResourceComponent()).getConnection();
    }

    @Override
    public void removeConnection() {
        ((DatabaseComponent)this.context.getParentResourceComponent()).removeConnection();
    }
}

