/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.DirUsage;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.platform.PlatformComponent;

public class DirectoryComponent
implements ResourceComponent<PlatformComponent>,
MeasurementFacet {
    private static final Log LOG = LogFactory.getLog(DirectoryComponent.class);
    private ResourceContext<PlatformComponent> resourceContext;

    public void start(ResourceContext<PlatformComponent> resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        DirUsage dirUsage = this.getDirectoryInfo();
        if (dirUsage != null) {
            return AvailabilityType.UP;
        }
        return AvailabilityType.DOWN;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        DirUsage dirUsage = this.getDirectoryInfo();
        if (dirUsage == null) {
            return;
        }
        for (MeasurementScheduleRequest request : requests) {
            Double value = null;
            if (request.getName().equals("usage")) {
                value = dirUsage.getDiskUsage();
            } else if (request.getName().equals("files")) {
                value = dirUsage.getFiles();
            } else if (request.getName().equals("total")) {
                value = dirUsage.getTotal();
            }
            if (value == null) continue;
            MeasurementDataNumeric result = new MeasurementDataNumeric(request, value);
            report.addData(result);
        }
    }

    private DirUsage getDirectoryInfo() {
        SystemInfo systemInfo = this.resourceContext.getSystemInformation();
        return systemInfo.getDirectoryUsage(this.resourceContext.getResourceKey());
    }
}

