/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hudson;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.hudson.HudsonJSONUtility;
import org.rhq.plugins.hudson.HudsonServerComponent;

public class HudsonProjectDiscoveryComponent
implements ResourceDiscoveryComponent<HudsonServerComponent> {
    private static final Log LOG = LogFactory.getLog(HudsonJSONUtility.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<HudsonServerComponent> discoveryContext) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> found = new HashSet<DiscoveredResourceDetails>();
        String serverPath = ((HudsonServerComponent)discoveryContext.getParentResourceComponent()).getPath();
        JSONObject server = HudsonJSONUtility.getData(serverPath, 1);
        JSONArray jobs = server.getJSONArray("jobs");
        try {
            for (int i = 0; i < jobs.length(); ++i) {
                JSONObject job = jobs.getJSONObject(i);
                String name = job.getString("name");
                String url = job.getString("url");
                String description = job.getString("description");
                if (description.length() > 1000) {
                    description = description.substring(0, 999);
                }
                DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), url, name, null, description, null, null);
                found.add(detail);
            }
            return found;
        }
        catch (Exception e) {
            LOG.warn((Object)e);
            throw e;
        }
    }
}

