/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.sql.DataSource;
import mazz.i18n.Logger;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DbUtilsI18NFactory;
import org.rhq.core.db.H2DatabaseType;
import org.rhq.core.db.H2v11DatabaseType;
import org.rhq.core.db.H2v12DatabaseType;
import org.rhq.core.db.Oracle10DatabaseType;
import org.rhq.core.db.Oracle11DatabaseType;
import org.rhq.core.db.Oracle12DatabaseType;
import org.rhq.core.db.Oracle8DatabaseType;
import org.rhq.core.db.Oracle9DatabaseType;
import org.rhq.core.db.OracleDatabaseType;
import org.rhq.core.db.Postgresql7DatabaseType;
import org.rhq.core.db.Postgresql81DatabaseType;
import org.rhq.core.db.Postgresql82DatabaseType;
import org.rhq.core.db.Postgresql83DatabaseType;
import org.rhq.core.db.Postgresql84DatabaseType;
import org.rhq.core.db.Postgresql8DatabaseType;
import org.rhq.core.db.Postgresql90DatabaseType;
import org.rhq.core.db.Postgresql91DatabaseType;
import org.rhq.core.db.PostgresqlDatabaseType;
import org.rhq.core.db.SQLServer2005DatabaseType;
import org.rhq.core.db.SQLServer2008DatabaseType;
import org.rhq.core.db.SQLServerDatabaseType;

public class DatabaseTypeFactory {
    private static final Logger LOG = DbUtilsI18NFactory.getLogger(DatabaseTypeFactory.class);
    private static final Map<String, Class<? extends DatabaseType>> DATABASE_TYPES = new Hashtable<String, Class<? extends DatabaseType>>();
    private static final Map<String, String> DB_URL_DRIVER_MAP;
    private static DatabaseType defaultDatabaseType;

    private DatabaseTypeFactory() {
    }

    public static void clearDatabaseTypeCache() {
        DATABASE_TYPES.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseType getDatabaseType(Context context, String datasource) throws Exception {
        Connection c = DatabaseTypeFactory.getConnection(context, datasource);
        try {
            DatabaseType databaseType = DatabaseTypeFactory.getDatabaseType(c);
            return databaseType;
        }
        finally {
            try {
                c.close();
            }
            catch (Exception e) {}
        }
    }

    public static Connection getConnection(Context context, String datasource) throws Exception {
        DataSource ds = (DataSource)context.lookup(datasource);
        return ds.getConnection();
    }

    public static DatabaseType getDatabaseType(Connection conn) throws Exception {
        String conn_class = conn.getClass().getName();
        Class<? extends DatabaseType> database_type_class = DATABASE_TYPES.get(conn_class);
        if (database_type_class == null) {
            DatabaseMetaData db_metadata = conn.getMetaData();
            String db_name = db_metadata.getDatabaseProductName().toLowerCase();
            String db_version = db_metadata.getDatabaseProductVersion().toLowerCase();
            LOG.debug("DatabaseTypeFactory.db-conn-metadata", new Object[]{db_name, db_version});
            if (db_name.indexOf("postgresql") != -1) {
                if (db_version.startsWith("7.")) {
                    database_type_class = Postgresql7DatabaseType.class;
                } else if (db_version.startsWith("9.0")) {
                    database_type_class = Postgresql90DatabaseType.class;
                } else if (db_version.startsWith("9.")) {
                    database_type_class = Postgresql91DatabaseType.class;
                } else if (db_version.startsWith("8.4")) {
                    database_type_class = Postgresql84DatabaseType.class;
                } else if (db_version.startsWith("8.3")) {
                    database_type_class = Postgresql83DatabaseType.class;
                } else if (db_version.startsWith("8.2")) {
                    database_type_class = Postgresql82DatabaseType.class;
                } else if (db_version.startsWith("8.1")) {
                    database_type_class = Postgresql81DatabaseType.class;
                } else if (db_version.startsWith("8.")) {
                    database_type_class = Postgresql8DatabaseType.class;
                }
            } else if (db_name.indexOf("oracle") != -1) {
                if (db_version.startsWith("oracle8")) {
                    database_type_class = Oracle8DatabaseType.class;
                } else if (db_version.startsWith("oracle9")) {
                    database_type_class = Oracle9DatabaseType.class;
                } else if (db_version.startsWith("oracle database 10g")) {
                    database_type_class = Oracle10DatabaseType.class;
                } else if (db_version.startsWith("oracle database 11g")) {
                    database_type_class = Oracle11DatabaseType.class;
                } else if (db_version.startsWith("oracle database 12c")) {
                    database_type_class = Oracle12DatabaseType.class;
                }
            } else if (db_name.indexOf("h2") != -1) {
                if (db_version.startsWith("1.1")) {
                    database_type_class = H2v11DatabaseType.class;
                } else if (db_version.startsWith("1.2")) {
                    database_type_class = H2v12DatabaseType.class;
                }
            } else if (db_name.indexOf("sql server") != -1) {
                if (db_version.startsWith("09.00") || db_version.startsWith("9.00")) {
                    database_type_class = SQLServer2005DatabaseType.class;
                } else if (db_version.startsWith("10.00")) {
                    database_type_class = SQLServer2008DatabaseType.class;
                }
            }
            if (database_type_class == null) {
                throw new Exception(DbUtilsI18NFactory.getMsg().getMsg("DatabaseTypeFactory.unknown-database", new Object[]{db_name, db_version}));
            }
            DATABASE_TYPES.put(conn_class, database_type_class);
        }
        return database_type_class.newInstance();
    }

    public static DatabaseType getDefaultDatabaseType() {
        return defaultDatabaseType;
    }

    public static void setDefaultDatabaseType(DatabaseType databaseType) {
        defaultDatabaseType = databaseType;
    }

    public static String loadJdbcDriver(String jdbc_url) {
        String ret_driver_class = null;
        for (Map.Entry<String, String> url_driver_entry : DB_URL_DRIVER_MAP.entrySet()) {
            String url_prefix = url_driver_entry.getKey();
            if (!jdbc_url.startsWith(url_prefix)) continue;
            String driver_class_to_load = url_driver_entry.getValue();
            try {
                Class.forName(driver_class_to_load);
                ret_driver_class = driver_class_to_load;
            }
            catch (ClassNotFoundException e) {
                LOG.warn("DatabaseTypeFactory.cannot-load-jdbc-driver", new Object[]{driver_class_to_load, jdbc_url});
            }
            break;
        }
        return ret_driver_class;
    }

    public static boolean isPostgres(Connection c) throws Exception {
        DatabaseType type = DatabaseTypeFactory.getDatabaseType(c);
        return DatabaseTypeFactory.isPostgres(type);
    }

    public static boolean isPostgres(DatabaseType type) {
        return type instanceof PostgresqlDatabaseType;
    }

    public static boolean isOracle(Connection c) throws Exception {
        DatabaseType type = DatabaseTypeFactory.getDatabaseType(c);
        return DatabaseTypeFactory.isOracle(type);
    }

    public static boolean isOracle(DatabaseType type) {
        return type instanceof OracleDatabaseType;
    }

    public static boolean isH2(Connection c) throws Exception {
        DatabaseType type = DatabaseTypeFactory.getDatabaseType(c);
        return DatabaseTypeFactory.isH2(type);
    }

    public static boolean isH2(DatabaseType type) {
        return type instanceof H2DatabaseType;
    }

    public static boolean isSQLServer(Connection c) throws Exception {
        DatabaseType type = DatabaseTypeFactory.getDatabaseType(c);
        return DatabaseTypeFactory.isSQLServer(type);
    }

    public static boolean isSQLServer(DatabaseType type) {
        return type instanceof SQLServerDatabaseType;
    }

    static {
        defaultDatabaseType = null;
        DB_URL_DRIVER_MAP = new Hashtable<String, String>();
        DB_URL_DRIVER_MAP.put("jdbc:postgresql:", "org.postgresql.Driver");
        DB_URL_DRIVER_MAP.put("jdbc:oracle:thin:@", "oracle.jdbc.driver.OracleDriver");
        DB_URL_DRIVER_MAP.put("jdbc:oracle:oci8:", "oracle.jdbc.driver.OracleDriver");
        DB_URL_DRIVER_MAP.put("jdbc:h2:", "org.h2.Driver");
        DB_URL_DRIVER_MAP.put("jdbc:jtds:sqlserver", "net.sourceforge.jtds.jdbc.Driver");
    }
}

