/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.upgrade;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import mazz.i18n.Logger;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DbUtilsI18NFactory;
import org.rhq.core.db.upgrade.DatabaseUpgradeTask;
import org.rhq.core.db.upgrade.DriftPathDirectoryDatabaseUpgradeTask;

public class DriftTemplateMapDatabaseUpgradeTask
implements DatabaseUpgradeTask {
    private static final Logger LOG = DbUtilsI18NFactory.getLogger(DriftPathDirectoryDatabaseUpgradeTask.class);

    @Override
    public void execute(DatabaseType databaseType, Connection connection) throws SQLException {
        String sql = " insert into RHQ_DRIFT_DEF_TEMPLATE (        ID,        RESOURCE_TYPE_ID,        CONFIG_ID,        NAME,        DESCRIPTION,        IS_USER_DEFINED,        CTIME ) select " + databaseType.getSequenceInsertValue(connection, "RHQ_DRIFT_DEF_TEMPLATE_ID_SEQ") + "," + "        tm.RESOURCE_TYPE_ID, " + "        ct.CONFIG_ID, " + "        ct.NAME, " + "        ct.DESCRIPTION, " + "        " + databaseType.getBooleanValue(false) + "," + "        " + System.currentTimeMillis() + "   from RHQ_DRIFT_TEMPLATE_MAP tm " + "   join RHQ_RESOURCE_TYPE rt on tm.RESOURCE_TYPE_ID = rt.ID" + "   join RHQ_CONFIG_TEMPLATE ct on tm.CONFIG_TEMPLATE_ID = ct.ID";
        LOG.debug("DatabaseType.executing-sql", new Object[]{sql});
        databaseType.executeSql(connection, sql);
        sql = " update RHQ_DRIFT_DEFINITION dd set DRIFT_DEF_TEMPLATE_ID = (   select dt.ID       from RHQ_DRIFT_DEF_TEMPLATE dt       join RHQ_RESOURCE_TYPE rt on dt.RESOURCE_TYPE_ID = rt.ID       join RHQ_RESOURCE res     on rt.ID = res.RESOURCE_TYPE_ID      where dd.RESOURCE_ID = res.ID ) where dd.DRIFT_DEF_TEMPLATE_ID is null";
        LOG.debug("DatabaseType.executing-sql", new Object[]{sql});
        databaseType.executeSql(connection, sql);
        sql = "select cs.ID from RHQ_DRIFT_CHANGE_SET cs where cs.VERSION = 0";
        LOG.debug("DatabaseType.executing-sql", new Object[]{sql});
        List<Object[]> rows = databaseType.executeSelectSql(connection, sql);
        sql = "insert into RHQ_DRIFT_SET ( ID ) values ( " + databaseType.getSequenceInsertValue(connection, "RHQ_DRIFT_SET_ID_SEQ") + " )";
        for (Object[] row : rows) {
            int csId = ((Number)row[0]).intValue();
            LOG.debug("DatabaseType.executing-sql", new Object[]{sql});
            databaseType.executeSql(connection, sql);
            int setId = databaseType.getSequenceValue(connection, "RHQ_DRIFT_SET", "ID");
            String updateSql = "update RHQ_DRIFT set DRIFT_SET_ID = " + setId + " where DRIFT_CHANGE_SET_ID = " + csId;
            LOG.debug("DatabaseType.executing-sql", new Object[]{updateSql});
            databaseType.executeSql(connection, updateSql);
            updateSql = "update RHQ_DRIFT_CHANGE_SET set DRIFT_SET_ID = " + setId + " where ID = " + csId;
            LOG.debug("DatabaseType.executing-sql", new Object[]{updateSql});
            databaseType.executeSql(connection, updateSql);
        }
    }
}

