/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.convert.seamtext.tags;

import org.richfaces.convert.seamtext.tags.HtmlTag;

class FormattingTag
extends HtmlTag {
    private static final long serialVersionUID = 2688496380368279023L;
    private String seamTag;
    private Boolean formating;

    public FormattingTag(String tagName, String seamTag) {
        super(tagName);
        this.seamTag = seamTag;
    }

    public void appendBody(HtmlTag tag) {
        super.appendBody(tag);
        if (!(tag instanceof FormattingTag)) {
            this.formating = false;
        }
    }

    public String print() {
        if (this.isFormating()) {
            return super.print();
        }
        return this.printPlain();
    }

    public String printEnd() {
        return this.seamTag;
    }

    public String printStart() {
        return this.seamTag;
    }

    public boolean isFormating() {
        if (this.formating != null) {
            return this.formating;
        }
        for (Object child : this.body) {
            if (child instanceof FormattingTag) {
                FormattingTag formattingChild = (FormattingTag)child;
                if (formattingChild.isFormating()) continue;
                this.formating = false;
                return false;
            }
            if (!(child instanceof HtmlTag)) continue;
            throw new IllegalStateException("It is imposible, in this case we must have formating = false");
        }
        this.formating = true;
        return true;
    }

    public String getSeamTag() {
        return this.seamTag;
    }

    public void setSeamTag(String seamTag) {
        this.seamTag = seamTag;
    }
}

