/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demos.library;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.switchyard.quickstarts.demos.library.types.Book;
import org.switchyard.quickstarts.demos.library.types.Loan;
import org.switchyard.quickstarts.demos.library.types.ObjectFactory;

public final class Library
implements Serializable {
    private static final Library INSTANCE = new Library();
    private static final Integer ZERO = 0;
    private final Map<String, Book> isbns_to_books = new TreeMap<String, Book>();
    private final Map<String, Integer> isbns_to_quantities = Collections.synchronizedMap(new TreeMap());
    private final Object librarian = new Object();

    private Library() {
        this.addBook("978-0-307-35193-7", "World War Z", "An Oral History of the Zombie War", 1);
        this.addBook("978-0-7360-9829-8", "Successful Sports Officiating", "American Sports Education Program.", 3);
        this.addBook("978-0-7434-8773-3", "The Time Machine", "H. G. Wells' story of a time traveler.", 8);
        this.addBook("978-1-101-15402-1", "The Island of Dr. Moreau", "H. G. Wells' story of what may be most relevant to modern ethical dimemmas.", 5);
        this.addBook("978-1-4000-5-80-2", "The Zombie Survival Guide", "Complete Protection from the Living Dead", 6);
        this.addBook("978-1-448-14153-1", "Doctor Who: Summer Falls", "Story of Amelia Williams.", 2);
        this.addBook("978-1-4516-7486-6", "Tesla, Man Out of Time", "Explores the brilliant and prescient mind of one of the twentieth century's greatest scientists and inventors, Nikola Tesla.", 4);
        this.addBook("978-1-59474-449-5", "Pride and Prejudice and Zombies", "The Classic Regency Romance -- Now with Ultraviolent Zombie Mayhem!", 7);
    }

    private void addBook(String isbn, String title, String synopsis, int quantity) {
        Book book = new Book();
        book.setIsbn(isbn);
        book.setTitle(title);
        book.setSynopsis(synopsis);
        this.isbns_to_books.put(isbn, book);
        this.isbns_to_quantities.put(isbn, quantity);
    }

    public Collection<Book> getAllBooks() {
        return this.isbns_to_books.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Book> getAvailableBooks() {
        Object object = this.librarian;
        synchronized (object) {
            LinkedList<Book> books = new LinkedList<Book>();
            for (Map.Entry<String, Integer> entry : this.isbns_to_quantities.entrySet()) {
                if (entry.getValue() <= 0) continue;
                books.add(this.getBook(entry.getKey()));
            }
            return books;
        }
    }

    public Book getBook(String isbn) {
        return this.isbns_to_books.get(isbn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getQuantity(String isbn) {
        Integer quantity = null;
        if (isbn != null) {
            Object object = this.librarian;
            synchronized (object) {
                quantity = this.isbns_to_quantities.get(isbn);
            }
        }
        return quantity != null ? quantity : ZERO;
    }

    public Integer getQuantity(Book book) {
        return book != null ? this.getQuantity(book.getIsbn()) : ZERO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Loan attemptLoan(String isbn, String loanId) {
        Loan loan = new Loan();
        loan.setId(loanId);
        Book book = this.getBook(isbn);
        if (book != null) {
            Object object = this.librarian;
            synchronized (object) {
                int quantity = this.getQuantity(book);
                if (quantity > 0) {
                    this.isbns_to_quantities.put(isbn, --quantity);
                    loan.setApproved(true);
                    loan.setNotes("Happy reading! Remaining copies: " + quantity);
                    loan.setBook(book);
                } else {
                    loan.setApproved(false);
                    loan.setNotes("Book has no copies available.");
                }
            }
        } else {
            loan.setApproved(false);
            loan.setNotes("No book matching isbn: " + isbn);
        }
        return loan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean returnLoan(Loan loan) {
        String isbn;
        Book book;
        if (loan != null && (book = loan.getBook()) != null && (isbn = book.getIsbn()) != null) {
            Object object = this.librarian;
            synchronized (object) {
                Integer quantity = this.isbns_to_quantities.get(isbn);
                if (quantity != null) {
                    quantity = new Integer(quantity + 1);
                    this.isbns_to_quantities.put(isbn, quantity);
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        return this.toString(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(boolean detailed) {
        StringWriter sw = new StringWriter();
        Object object = this.librarian;
        synchronized (object) {
            try {
                if (detailed) {
                    JAXBContext ctx = JAXBContext.newInstance((String)"org.switchyard.quickstarts.demos.library.types");
                    Marshaller m = ctx.createMarshaller();
                    m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                    m.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
                    ObjectFactory of = new ObjectFactory();
                    for (Book book : this.isbns_to_books.values()) {
                        int quantity = this.isbns_to_quantities.get(book.getIsbn());
                        sw.write("\nBook (quantity=" + quantity + ")\n");
                        m.marshal(of.createBook(book), (Writer)sw);
                        sw.write(10);
                    }
                } else {
                    for (Book book : this.isbns_to_books.values()) {
                        int quantity = this.isbns_to_quantities.get(book.getIsbn());
                        sw.write(book.getTitle() + " (" + quantity + ")\n");
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return sw.toString().trim();
    }

    public static final Library library() {
        return INSTANCE;
    }

    public static void main(String ... args) {
        System.out.println(Library.library().toString(false));
        System.out.println();
        System.out.println(Library.library().toString(true));
    }
}

