/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demo.policy.transaction;

import javax.inject.Inject;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.switchyard.annotations.Requires;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.policy.TransactionPolicy;
import org.switchyard.quickstarts.demo.policy.transaction.StoreService;
import org.switchyard.quickstarts.demo.policy.transaction.TaskBService;
import org.switchyard.runtime.util.TransactionManagerLocator;

@Service(value=TaskBService.class)
@Requires(transaction={TransactionPolicy.SUSPENDS_TRANSACTION, TransactionPolicy.MANAGED_TRANSACTION_LOCAL})
public class TaskBServiceBean
implements TaskBService {
    public static final String ROLLBACK = "rollback.B";
    private int _rollbackCounter = 0;
    @Inject
    @Reference(value="StoreBService")
    @Requires(transaction={TransactionPolicy.SUSPENDS_TRANSACTION})
    private StoreService _storeB;

    @Override
    public final void doTask(String command) {
        this.print("Received command =>  " + command);
        Transaction t = null;
        try {
            t = this.getCurrentTransaction();
        }
        catch (Exception e) {
            this.print("Failed to get current transcation");
        }
        if (t == null) {
            this.print("No active transaction");
            return;
        }
        this._storeB.store(command);
        if (command.contains(ROLLBACK)) {
            try {
                if (++this._rollbackCounter % 4 != 0) {
                    t.setRollbackOnly();
                    this.print("Marked transaction to rollback!");
                } else {
                    this.print("Rollbacks completed - will be committed");
                }
            }
            catch (Exception ex) {
                this.print("Failed to rollback transaction: " + ex.toString());
            }
        }
    }

    private Transaction getCurrentTransaction() throws Exception {
        TransactionManager tm = TransactionManagerLocator.locateTransactionManager();
        return tm.getTransaction();
    }

    private void print(String message) {
        System.out.println(":: TaskBService :: " + message);
    }
}

