/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demo.security.propagation.basic;

import javax.ejb.EJB;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeSecurity;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.quickstarts.demo.security.propagation.basic.BackEndService;
import org.switchyard.quickstarts.demo.security.propagation.basic.Work;
import org.switchyard.quickstarts.demo.security.propagation.basic.WorkAck;
import org.switchyard.quickstarts.demo.security.propagation.basic.WorkService;
import org.switchyard.quickstarts.demo.security.propagation.ejb.TestEJBBeanLocal;

@Service(value=WorkService.class)
public class WorkServiceBean
implements WorkService {
    private static final Logger LOGGER = Logger.getLogger(WorkServiceBean.class);
    private static final String MSG_1 = ":: WorkService :: Received work command => %s (caller principal=%s, in roles? 'friend'=%s 'enemy'=%s)";
    private static final String MSG_2 = ":: WorkService :: returned from BackEndService => %s";
    private static final String MSG_3 = ":: WorkService :: returned from TestEJBBean => %s";
    @Inject
    private Exchange exchange;
    @Inject
    @Reference
    private BackEndService backEndService;
    @EJB(lookup="java:global/switchyard-demo-security-propagation-ejb/TestEJBBean")
    private TestEJBBeanLocal testEjb;

    @Override
    public WorkAck doWork(Work work) {
        String cmd = work.getCommand();
        ExchangeSecurity es = this.exchange.getSecurity();
        String msg1 = String.format(MSG_1, cmd, es.getCallerPrincipal(), es.isCallerInRole("friend"), es.isCallerInRole("enemy"));
        LOGGER.info((Object)msg1);
        String back = this.backEndService.process(cmd);
        String msg2 = String.format(MSG_2, back);
        LOGGER.info((Object)msg2);
        String ejbret = this.testEjb.process(cmd);
        String msg3 = String.format(MSG_3, ejbret);
        LOGGER.info((Object)msg3);
        return new WorkAck().setCommand(cmd).setReceived(true);
    }
}

