/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demo.policy.transaction;

import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.switchyard.annotations.Requires;
import org.switchyard.component.bean.Service;
import org.switchyard.policy.TransactionPolicy;
import org.switchyard.quickstarts.demo.policy.transaction.TaskCService;

@Service(value=TaskCService.class)
@Requires(transaction={TransactionPolicy.SUSPENDS_TRANSACTION, TransactionPolicy.NO_MANAGED_TRANSACTION})
public class TaskCServiceBean
implements TaskCService {
    public static final String ROLLBACK = "rollback.C";
    private static final String JNDI_TRANSACTION_MANAGER = "java:jboss/TransactionManager";

    @Override
    public final void doTask(String command) {
        this.print("Received command =>  " + command);
        Transaction t = null;
        try {
            t = this.getCurrentTransaction();
        }
        catch (Exception e) {
            this.print("Failed to get current transcation");
        }
        if (t == null) {
            this.print("No active transaction");
        } else {
            this.print("[Error] Managed transaction exists in spite of being marked as " + TransactionPolicy.NO_MANAGED_TRANSACTION);
        }
        if (command.contains(ROLLBACK)) {
            this.print(String.format("This service requires %s, so it never has transaction to rollback.", TransactionPolicy.NO_MANAGED_TRANSACTION));
        }
    }

    private Transaction getCurrentTransaction() throws Exception {
        TransactionManager tm = (TransactionManager)new InitialContext().lookup(JNDI_TRANSACTION_MANAGER);
        return tm.getTransaction();
    }

    private void print(String message) {
        System.out.println(":: TaskCService :: " + message);
    }
}

