/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demo.policy.transaction;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.client.HornetQQueue;
import org.switchyard.quickstarts.demo.policy.transaction.ClientUtil;

public final class HornetQClient {
    private static final String DEFAULT_QUEUE_NAME = "policyQSTransacted";
    private static final String DEFAULT_PAYLOAD = "rollback";

    private HornetQClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        HornetQConnectionFactory hornetQConnectionFactory = null;
        Connection connection = null;
        Session session = null;
        String queueName = DEFAULT_QUEUE_NAME;
        String payload = DEFAULT_PAYLOAD;
        if (args.length > 0) {
            payload = args[0];
        }
        if (args.length > 1) {
            queueName = args[1];
        }
        System.out.println("Using queue name: " + queueName);
        System.out.println("Using payload: " + payload);
        try {
            hornetQConnectionFactory = new HornetQConnectionFactory(false, new TransportConfiguration[]{new TransportConfiguration(NettyConnectorFactory.class.getName())});
            connection = hornetQConnectionFactory.createConnection();
            connection.start();
            session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)new HornetQQueue(queueName));
            producer.send((Message)session.createTextMessage(payload));
            System.out.println("Message sent. Please see server console output");
        }
        catch (Throwable throwable) {
            ClientUtil.closeSession(session);
            ClientUtil.closeConnection(connection);
            ClientUtil.closeConnectionFactory(hornetQConnectionFactory);
            throw throwable;
        }
        ClientUtil.closeSession(session);
        ClientUtil.closeConnection(connection);
        ClientUtil.closeConnectionFactory(hornetQConnectionFactory);
    }
}

