/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.camel.sap.binding.composer;

import java.util.Date;
import org.eclipse.emf.ecore.EObject;
import org.fusesource.camel.component.sap.SAPEndpoint;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.model.rfc.Table;
import org.fusesource.camel.component.sap.util.RfcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.switchyard.Exchange;
import org.switchyard.component.camel.common.composer.CamelBindingData;
import org.switchyard.component.camel.common.composer.CamelMessageComposer;
import org.switchyard.quickstarts.camel.sap.binding.jaxb.BookFlightRequest;

public class GetFlightConnectionListMessageComposer
extends CamelMessageComposer {
    private static final Logger LOG = LoggerFactory.getLogger(GetFlightConnectionListMessageComposer.class);

    public CamelBindingData decompose(Exchange exchange, CamelBindingData target) throws Exception {
        CamelBindingData response = super.decompose(exchange, target);
        BookFlightRequest bookFlightRequest = (BookFlightRequest)exchange.getMessage().getContent(BookFlightRequest.class);
        SAPEndpoint endpoint = (SAPEndpoint)response.getMessage().getExchange().getContext().getEndpoint("sap:destination:nplDest:BAPI_FLCONN_GETLIST", SAPEndpoint.class);
        Structure request = endpoint.getRequest();
        if (bookFlightRequest.getTravelAgencyNumber() != null && bookFlightRequest.getTravelAgencyNumber().length() > 0) {
            request.put((Object)"TRAVELAGENCY", (Object)bookFlightRequest.getTravelAgencyNumber());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added TRAVELAGENCY = '{}' to request", (Object)bookFlightRequest.getTravelAgencyNumber());
            }
        } else {
            throw new Exception("No Travel Agency Number");
        }
        if (bookFlightRequest.getFlightDate() != null) {
            Table table = (Table)request.get((Object)"DATE_RANGE", Table.class);
            Structure date_range = table.add();
            date_range.put((Object)"SIGN", (Object)"I");
            date_range.put((Object)"OPTION", (Object)"EQ");
            Date date = bookFlightRequest.getFlightDate();
            date_range.put((Object)"LOW", (Object)date);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added DATE_RANGE = '{}' to request", (Object)RfcUtil.marshal((EObject)table));
            }
        } else {
            throw new Exception("No Flight Date");
        }
        if (bookFlightRequest.getStartAirportCode() != null && bookFlightRequest.getStartAirportCode().length() > 0) {
            Structure destination_from = (Structure)request.get((Object)"DESTINATION_FROM", Structure.class);
            destination_from.put((Object)"AIRPORTID", (Object)bookFlightRequest.getStartAirportCode());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added DESTINATION_FROM = '{}' to request", (Object)RfcUtil.marshal((EObject)destination_from));
            }
        } else {
            throw new Exception("No Start Destination");
        }
        if (bookFlightRequest.getEndAirportCode() != null && bookFlightRequest.getEndAirportCode().length() > 0) {
            Structure destination_to = (Structure)request.get((Object)"DESTINATION_TO", Structure.class);
            destination_to.put((Object)"AIRPORTID", (Object)bookFlightRequest.getEndAirportCode());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added DESTINATION_TO = '{}' to request", (Object)RfcUtil.marshal((EObject)destination_to));
            }
        } else {
            throw new Exception("No End Destination");
        }
        response.getMessage().setBody((Object)request);
        return response;
    }
}

