/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.bpel.xts.wsat.ws;

import com.arjuna.wst.Aborted;
import com.arjuna.wst.Durable2PCParticipant;
import com.arjuna.wst.Prepared;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.Vote;
import com.arjuna.wst.WrongStateException;
import java.io.Serializable;
import java.util.logging.Logger;
import org.switchyard.quickstarts.bpel.xts.wsat.ws.AirportManager;

public class OrderParticipant
implements Durable2PCParticipant,
Serializable {
    private static final long serialVersionUID = -6459800278322126331L;
    private static Logger log = Logger.getLogger(OrderParticipant.class.getName());
    private String _txID;
    private String _name;
    private String _fltid;

    public OrderParticipant(String txID, String name, String fltid) {
        this._txID = txID;
        this._name = name;
        this._fltid = fltid;
    }

    public String getTxID() {
        return this._txID;
    }

    public Vote prepare() throws WrongStateException, SystemException {
        boolean state = AirportManager.checkFLTID(this._fltid);
        if (state) {
            log.info("\n================================================================================\nAirportOrderParticipant " + this._fltid + " prepare: prepared" + "\n================================================================================");
            return new Prepared();
        }
        log.info("\n================================================================================\nAirportOrderParticipant " + this._fltid + " prepare: aborted" + "\n================================================================================");
        return new Aborted();
    }

    public void commit() throws WrongStateException, SystemException {
        log.info("\n================================================================================\nAirportOrderParticipant " + this._fltid + " commit" + "\n================================================================================");
    }

    public void rollback() throws WrongStateException, SystemException {
        log.info("\n================================================================================\nAirportOrderParticipant " + this._fltid + " rollback" + "\n================================================================================");
    }

    public void unknown() throws SystemException {
    }

    public void error() throws SystemException {
    }
}

