/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.camel.bus;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.log4j.Logger;

public class CountingProcessor
extends DelegateAsyncProcessor {
    private Logger _logger = Logger.getLogger(CountingProcessor.class);
    private final ProcessorDefinition<?> _node;

    public CountingProcessor(ProcessorDefinition<?> definition, Processor target) {
        super(target);
        this._node = definition;
    }

    public boolean process(Exchange exchange, final AsyncCallback callback) {
        final long time = System.currentTimeMillis();
        return super.process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (doneSync) {
                    long processingTime = System.currentTimeMillis() - time;
                    CountingProcessor.this._logger.info((Object)("Route node " + CountingProcessor.this._node.getLabel() + " took " + processingTime + " ms"));
                }
                callback.done(doneSync);
            }
        });
    }
}

