/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.camel.jms.binding;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.switchyard.quickstarts.camel.jms.binding.ClientUtil;

public final class JMSClient {
    private static final String QUEUE_NAME = "queue/GreetingServiceQueue";
    private static final String MESSAGE_PAYLOAD = "/test.txt";

    private JMSClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        InitialContext initialContext = null;
        Connection connection = null;
        Session session = null;
        try {
            Properties env = new Properties();
            env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            env.put("java.naming.provider.url", "jnp://localhost:1099");
            env.put("java.naming.factory.url.pkgs", "org.jboss.naming,org.jnp.interfaces");
            initialContext = new InitialContext(env);
            ConnectionFactory conFactory = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = conFactory.createConnection();
            connection.start();
            Destination destination = (Destination)initialContext.lookup(QUEUE_NAME);
            session = connection.createSession(false, 2);
            MessageProducer producer = session.createProducer(destination);
            TextMessage message = session.createTextMessage(ClientUtil.readFileContent(MESSAGE_PAYLOAD));
            producer.send((Message)message);
            System.out.println("Message sent. Please see server console output");
        }
        catch (Throwable throwable) {
            ClientUtil.closeContext(initialContext);
            ClientUtil.closeSession(session);
            ClientUtil.closeConnection(connection);
            throw throwable;
        }
        ClientUtil.closeContext(initialContext);
        ClientUtil.closeSession(session);
        ClientUtil.closeConnection(connection);
    }
}

