/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.camel.rest.binding;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.quickstarts.camel.rest.binding.Item;
import org.switchyard.quickstarts.camel.rest.binding.Order;
import org.switchyard.quickstarts.camel.rest.binding.OrderItem;
import org.switchyard.quickstarts.camel.rest.binding.OrderService;
import org.switchyard.quickstarts.camel.rest.binding.Warehouse;

@Service(value=OrderService.class)
public class OrderServiceImpl
implements OrderService {
    private static final Logger LOGGER = Logger.getLogger(OrderService.class);
    private static final String SUCCESS = "Order service is DUMB!";
    private static Integer orderNo = 0;
    private ConcurrentMap<Integer, Order> _orders = new ConcurrentHashMap<Integer, Order>();
    @Inject
    @Reference
    private Warehouse _warehouse;

    @Override
    public Order newOrder() {
        Integer n = orderNo;
        Integer n2 = orderNo = Integer.valueOf(orderNo + 1);
        LOGGER.info((Object)("Creating new Order with no: " + orderNo));
        Order order = new Order(orderNo);
        this._orders.put(orderNo, order);
        return order;
    }

    @Override
    public Order getOrder(Integer orderId) throws Exception {
        Order corder = (Order)this._orders.get(orderId);
        if (corder == null) {
            throw new RuntimeException("Order " + orderId + " not found!");
        }
        for (OrderItem orderItem : corder.getItems()) {
            Item item = this._warehouse.getItem(orderItem.getItem().getItemId());
            orderItem.setItem(item);
        }
        return corder;
    }

    @Override
    public String addItems(Order order) throws Exception {
        Order corder = this.getOrder(order.getOrderId());
        for (OrderItem orderItem : order.getItems()) {
            Item item = this._warehouse.getItem(orderItem.getItem().getItemId());
            if (item == null) {
                throw new RuntimeException("Item " + orderItem.getItem().getItemId() + " not found!");
            }
            orderItem.setItem(item);
            corder.getItems().add(orderItem);
        }
        LOGGER.info((Object)("Order after adding items: " + corder));
        return SUCCESS;
    }

    @Override
    public String removeItem(String orderItemId) throws Exception {
        String[] ids = orderItemId.split(":");
        if (ids.length != 2) {
            throw new RuntimeException("Missing either order id or item id!");
        }
        Integer orderId = Integer.parseInt(ids[0]);
        Integer itemId = Integer.parseInt(ids[1]);
        Order corder = this.getOrder(orderId);
        for (OrderItem orderItem : corder.getItems()) {
            if (orderItem.getItem().getItemId() != itemId) continue;
            corder.getItems().remove(orderItem);
            break;
        }
        LOGGER.info((Object)("Order after deleting item: " + corder));
        return SUCCESS;
    }

    @Override
    public Boolean isInventorySetup() {
        int size = this._warehouse.getItemCount();
        System.out.println(".... Inventory: " + size);
        return size > 0;
    }

    @Override
    public String createInventory() throws Exception {
        this._warehouse.addItem(new Item(1, "Hydrogen Atom - No, we are not kidding!"));
        this._warehouse.addItem(new Item(2, "Handcrafted Copper Plate"));
        this._warehouse.addItem(new Item(3, "Einstein's Bust - Talks about your future :)"));
        this._warehouse.addItem(new Item(4, "Time Machine"));
        return SUCCESS;
    }

    @Override
    public String updateInventory() throws Exception {
        this._warehouse.updateItem(new Item(1, "Water"));
        this._warehouse.updateItem(new Item(2, "Cuttlery"));
        this._warehouse.updateItem(new Item(3, "Theory of relativity"));
        this._warehouse.updateItem(new Item(4, "Coffee Maker"));
        return SUCCESS;
    }

    @Override
    public String removeInventory() throws Exception {
        this._warehouse.removeItem(1);
        this._warehouse.removeItem(2);
        this._warehouse.removeItem(3);
        this._warehouse.removeItem(4);
        return SUCCESS;
    }
}

