/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.rest.binding;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.switchyard.component.bean.Service;
import org.switchyard.quickstarts.rest.binding.Item;
import org.switchyard.quickstarts.rest.binding.ItemNotFoundException;
import org.switchyard.quickstarts.rest.binding.WarehouseService;

@Service(value=WarehouseService.class)
public class WarehouseServiceImpl
implements WarehouseService {
    private static final Logger LOGGER = Logger.getLogger(WarehouseService.class);
    private static final String SUCCESS = "SUCCESS";
    private ConcurrentMap<Integer, Item> items = new ConcurrentHashMap<Integer, Item>();

    @Override
    public Item getItem(Integer itemId) throws Exception {
        System.out.println("++++++ getItem " + itemId);
        Item item = (Item)this.items.get(itemId);
        if (item == null) {
            throw new ItemNotFoundException("Item " + itemId + " not found!");
        }
        return item;
    }

    @Override
    public String addItem(Item item) throws Exception {
        if (this.items.get(item.getItemId()) == null) {
            this.items.put(item.getItemId(), item);
            LOGGER.info((Object)("Added item " + item.getItemId() + " with name " + item.getName()));
        }
        return SUCCESS;
    }

    @Override
    public String updateItem(Item item) throws Exception {
        Item item2 = (Item)this.items.get(item.getItemId());
        item2.setName(item.getName());
        LOGGER.info((Object)("Updated item " + item.getItemId() + " with name " + item.getName()));
        return SUCCESS;
    }

    @Override
    public String removeItem(Integer itemId) throws Exception {
        if (this.getItem(itemId) == null) {
            throw new ItemNotFoundException("Item " + itemId + " not found!");
        }
        this.items.remove(itemId);
        LOGGER.info((Object)("Removed item " + itemId));
        return SUCCESS;
    }

    @Override
    public Integer getItemCount() {
        System.out.println("++++++ getItemCount ");
        return this.items.size();
    }
}

