/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.admin.Application;
import org.switchyard.admin.ComponentService;
import org.switchyard.admin.Service;
import org.switchyard.admin.Transformer;
import org.switchyard.admin.Validator;
import org.switchyard.admin.base.BaseJavaComponentService;
import org.switchyard.admin.base.BaseNoopComponentService;
import org.switchyard.admin.base.BaseService;
import org.switchyard.admin.base.BaseTransformer;
import org.switchyard.admin.base.BaseValidator;
import org.switchyard.admin.base.BaseWsdlComponentService;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.transform.TransformModel;
import org.switchyard.config.model.validate.ValidateModel;

public class BaseApplication
implements Application {
    private QName _name;
    private Map<QName, Service> _services;
    private Map<QName, ComponentService> _componentServices;
    private List<Transformer> _transformers;
    private List<Validator> _validators;
    private SwitchYardModel _config;

    public BaseApplication(QName name, SwitchYardModel config) {
        this._name = name;
        this._config = config;
        this.addTransformers();
        this.addValidators();
        this.addComponents();
        this.addServices();
    }

    @Override
    public QName getName() {
        return this._name;
    }

    @Override
    public List<Service> getServices() {
        if (this._services == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Service>(this._services.values());
    }

    @Override
    public Service getService(QName serviceName) {
        if (this._services == null) {
            return null;
        }
        return this._services.get(serviceName);
    }

    @Override
    public SwitchYardModel getConfig() {
        return this._config;
    }

    @Override
    public List<ComponentService> getComponentServices() {
        if (this._componentServices == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ComponentService>(this._componentServices.values());
    }

    @Override
    public ComponentService getComponentService(QName componentServiceName) {
        if (this._componentServices == null) {
            return null;
        }
        return this._componentServices.get(componentServiceName);
    }

    @Override
    public List<Transformer> getTransformers() {
        return Collections.unmodifiableList(this._transformers);
    }

    @Override
    public List<Validator> getValidators() {
        return Collections.unmodifiableList(this._validators);
    }

    private void addServices() {
        this._services = new LinkedHashMap<QName, Service>();
        if (this._config.getComposite().getServices() == null) {
            return;
        }
        for (CompositeServiceModel service : this._config.getComposite().getServices()) {
            this._services.put(service.getQName(), new BaseService(service, this));
        }
    }

    private void addTransformers() {
        this._transformers = new LinkedList<Transformer>();
        if (this._config.getTransforms() == null) {
            return;
        }
        for (TransformModel transformModel : this._config.getTransforms().getTransforms()) {
            this._transformers.add(new BaseTransformer(transformModel));
        }
    }

    private void addValidators() {
        this._validators = new LinkedList<Validator>();
        if (this._config.getValidates() == null) {
            return;
        }
        for (ValidateModel validateModel : this._config.getValidates().getValidates()) {
            this._validators.add(new BaseValidator(validateModel));
        }
    }

    private void addComponents() {
        this._componentServices = new LinkedHashMap<QName, ComponentService>();
        if (this._config.getComposite().getComponents() == null) {
            return;
        }
        for (ComponentModel component : this._config.getComposite().getComponents()) {
            if (component.getServices().size() <= 0) continue;
            ComponentServiceModel service = (ComponentServiceModel)component.getServices().get(0);
            if (service.getInterface() == null) {
                this._componentServices.put(service.getQName(), new BaseNoopComponentService(service, component, this));
                continue;
            }
            if ("java".equals(service.getInterface().getType())) {
                this._componentServices.put(service.getQName(), new BaseJavaComponentService(service, component, this));
                continue;
            }
            if (!"wsdl".equals(service.getInterface().getType())) continue;
            this._componentServices.put(service.getQName(), new BaseWsdlComponentService(service, component, this));
        }
    }
}

