/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.admin.Application;
import org.switchyard.admin.Binding;
import org.switchyard.admin.Reference;
import org.switchyard.admin.base.BaseBinding;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;

public class BaseReference
implements Reference {
    private QName _name;
    private String _referenceInterface;
    private Application _application;
    private String _promotedReference;
    private List<Binding> _gateways = new LinkedList<Binding>();

    public BaseReference(QName name, String referenceInterface, Application application, String reference, List<Binding> gateways) {
        this._name = name;
        this._referenceInterface = referenceInterface;
        this._application = application;
        this._promotedReference = reference;
        this._gateways = gateways;
    }

    public BaseReference(CompositeReferenceModel referenceConfig, Application application) {
        this._name = referenceConfig.getQName();
        this._application = application;
        if (referenceConfig.getInterface() != null) {
            this._referenceInterface = referenceConfig.getInterface().getInterface();
        }
        this._promotedReference = referenceConfig.getPromote();
        this._gateways = new ArrayList<Binding>();
        int idx = 1;
        for (BindingModel bindingModel : referenceConfig.getBindings()) {
            String name = bindingModel.getType() + idx++;
            this._gateways.add(new BaseBinding(bindingModel.getType(), name, bindingModel.toString()));
        }
    }

    @Override
    public Application getApplication() {
        return this._application;
    }

    @Override
    public List<Binding> getGateways() {
        return this._gateways;
    }

    @Override
    public String getPromotedReference() {
        return this._promotedReference;
    }

    @Override
    public String getInterface() {
        return this._referenceInterface;
    }

    @Override
    public QName getName() {
        return this._name;
    }
}

