/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.admin.Application;
import org.switchyard.admin.Binding;
import org.switchyard.admin.ComponentService;
import org.switchyard.admin.Service;
import org.switchyard.admin.base.BaseBinding;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;

public class BaseService
implements Service {
    private QName _name;
    private String _serviceInterface;
    private Application _application;
    private ComponentService _promotedService;
    private List<Binding> _gateways = new LinkedList<Binding>();

    public BaseService(QName name, String serviceInterface, Application application, ComponentService implementation, List<Binding> gateways) {
        this._name = name;
        this._serviceInterface = serviceInterface;
        this._application = application;
        this._promotedService = implementation;
        this._gateways = gateways;
    }

    public BaseService(CompositeServiceModel serviceConfig, Application application) {
        this._name = serviceConfig.getQName();
        this._application = application;
        if (serviceConfig.getInterface() != null) {
            this._serviceInterface = serviceConfig.getInterface().getInterface();
        }
        this._promotedService = this.getPromotedService(application, serviceConfig);
        this._gateways = new ArrayList<Binding>();
        int idx = 1;
        for (BindingModel bindingModel : serviceConfig.getBindings()) {
            String name = bindingModel.getType() + idx++;
            this._gateways.add(new BaseBinding(bindingModel.getType(), name, bindingModel.toString()));
        }
    }

    @Override
    public Application getApplication() {
        return this._application;
    }

    @Override
    public List<Binding> getGateways() {
        return this._gateways;
    }

    @Override
    public ComponentService getPromotedService() {
        return this._promotedService;
    }

    @Override
    public String getInterface() {
        return this._serviceInterface;
    }

    @Override
    public QName getName() {
        return this._name;
    }

    private ComponentService getPromotedService(Application application, CompositeServiceModel compositeService) {
        ComponentServiceModel componentServiceModel = compositeService.getComponentService();
        if (componentServiceModel == null) {
            return null;
        }
        return application.getComponentService(componentServiceModel.getQName());
    }
}

