/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import java.util.EventObject;
import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.admin.Application;
import org.switchyard.admin.ComponentReference;
import org.switchyard.admin.Service;
import org.switchyard.admin.ServiceOperation;
import org.switchyard.admin.SwitchYard;
import org.switchyard.admin.base.BaseApplication;
import org.switchyard.admin.base.BaseComponentReference;
import org.switchyard.admin.base.BaseComponentService;
import org.switchyard.admin.base.BaseSwitchYard;
import org.switchyard.admin.mbean.internal.LocalManagement;
import org.switchyard.admin.mbean.internal.MBeans;
import org.switchyard.deploy.ServiceDomainManager;
import org.switchyard.deploy.event.ApplicationDeployedEvent;
import org.switchyard.deploy.event.ApplicationUndeployedEvent;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.event.EventObserver;
import org.switchyard.runtime.event.ExchangeCompletionEvent;

public class SwitchYardBuilder
implements EventObserver {
    private BaseSwitchYard _switchYard = new BaseSwitchYard();
    private ServiceDomainManager _domainManager;

    public void init(ServiceDomainManager domainManager) {
        this._domainManager = domainManager;
        LocalManagement lm = new LocalManagement(this._domainManager);
        MBeans.registerLocalManagement(lm);
        this._domainManager.getEventManager().addObserver((EventObserver)this, ExchangeCompletionEvent.class).addObserver((EventObserver)this, ApplicationDeployedEvent.class).addObserver((EventObserver)this, ApplicationUndeployedEvent.class);
    }

    public void destroy() {
        this._domainManager.getEventManager().removeObserver((EventObserver)this);
        MBeans.unregisterLocalManagement();
    }

    public SwitchYard getSwitchYard() {
        return this._switchYard;
    }

    public ServiceDomainManager getDomainManager() {
        return this._domainManager;
    }

    public void notify(EventObject event) {
        if (event instanceof ApplicationDeployedEvent) {
            this.applicationDeployed((ApplicationDeployedEvent)event);
        } else if (event instanceof ApplicationUndeployedEvent) {
            this.applicationUndeployed((ApplicationUndeployedEvent)event);
        } else if (event instanceof ExchangeCompletionEvent) {
            this.exchangeCompleted((ExchangeCompletionEvent)event);
        }
    }

    void applicationDeployed(ApplicationDeployedEvent event) {
        AbstractDeployment deployment = event.getDeployment();
        if (deployment.getName() != null) {
            BaseApplication app = new BaseApplication(deployment.getName(), deployment.getConfig());
            this._switchYard.addApplication(app);
            MBeans.registerApplication(app);
        }
    }

    void applicationUndeployed(ApplicationUndeployedEvent event) {
        Application app;
        AbstractDeployment deployment = event.getDeployment();
        if (deployment.getName() != null && (app = this._switchYard.getApplication(deployment.getName())) != null) {
            MBeans.unregisterApplication(app);
            this._switchYard.removeApplication(deployment.getName());
        }
    }

    void exchangeCompleted(ExchangeCompletionEvent event) {
        for (Service service : this._switchYard.getServices()) {
            Exchange exchange = event.getExchange();
            QName serviceName = exchange.getProvider().getName();
            String operationName = exchange.getContract().getProviderOperation().getName();
            if (service.getName().equals(serviceName)) {
                this._switchYard.recordMetrics(exchange);
                BaseComponentService cs = (BaseComponentService)service.getPromotedService();
                cs.recordMetrics(exchange);
                for (ServiceOperation serviceOperation : cs.getServiceOperations()) {
                    if (!serviceOperation.getName().equals(operationName)) continue;
                    serviceOperation.recordMetrics(exchange);
                }
            }
            for (ComponentReference reference : service.getPromotedService().getReferences()) {
                if (!reference.getName().equals(event.getExchange().getConsumer().getName())) continue;
                ((BaseComponentReference)reference).recordMetrics(exchange);
            }
        }
    }
}

