/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.admin.Application;
import org.switchyard.admin.Binding;
import org.switchyard.admin.Reference;
import org.switchyard.admin.ServiceOperation;
import org.switchyard.admin.base.BaseApplication;
import org.switchyard.admin.base.BaseBinding;
import org.switchyard.admin.base.BaseMessageMetricsAware;
import org.switchyard.admin.base.BaseServiceOperation;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.extensions.java.JavaService;
import org.switchyard.extensions.wsdl.WSDLReaderException;
import org.switchyard.extensions.wsdl.WSDLService;

public class BaseReference
extends BaseMessageMetricsAware
implements Reference {
    private QName _name;
    private String _referenceInterface;
    private BaseApplication _application;
    private String _promotedReference;
    private Map<String, Binding> _gateways = new LinkedHashMap<String, Binding>();
    private List<ServiceOperation> _operations = new LinkedList<ServiceOperation>();

    public BaseReference(QName name, String referenceInterface, BaseApplication application, String reference, Map<String, Binding> gateways) {
        this._name = name;
        this._referenceInterface = referenceInterface;
        this._application = application;
        this._promotedReference = reference;
        this._gateways = gateways;
    }

    public BaseReference(CompositeReferenceModel referenceConfig, BaseApplication application) {
        this._name = referenceConfig.getQName();
        this._application = application;
        if (referenceConfig.getInterface() != null) {
            this._referenceInterface = referenceConfig.getInterface().getInterface();
        }
        this._promotedReference = referenceConfig.getPromote();
        this._gateways = new LinkedHashMap<String, Binding>();
        int idx = 0;
        for (BindingModel bindingModel : referenceConfig.getBindings()) {
            String name = bindingModel.getName() == null ? "_" + this._name.getLocalPart() + "_" + bindingModel.getType() + "_" + ++idx : bindingModel.getName();
            this._gateways.put(name, new BaseBinding(this._application, this._name, bindingModel.getType(), name, bindingModel.toString()));
        }
        this._operations = new LinkedList<ServiceOperation>();
        for (org.switchyard.metadata.ServiceOperation so : this.getInterfaceOperations(referenceConfig.getInterface())) {
            this._operations.add(new BaseServiceOperation(so.getName(), so.getExchangePattern().name(), so.getInputType(), so.getOutputType(), so.getFaultType()));
        }
    }

    private Collection<org.switchyard.metadata.ServiceOperation> getInterfaceOperations(InterfaceModel interfaceModel) {
        if (interfaceModel == null || "esb".equals(interfaceModel.getType())) {
            return Collections.emptySet();
        }
        if ("java".equals(interfaceModel.getType())) {
            return JavaService.fromClass((Class)Classes.forName((String)interfaceModel.getInterface())).getOperations();
        }
        if ("wsdl".equals(interfaceModel.getType())) {
            try {
                return WSDLService.fromWSDL((String)interfaceModel.getInterface()).getOperations();
            }
            catch (WSDLReaderException e) {
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    @Override
    public Application getApplication() {
        return this._application;
    }

    @Override
    public List<Binding> getGateways() {
        return new ArrayList<Binding>(this._gateways.values());
    }

    @Override
    public Binding getGateway(String gatewayName) {
        if (this._gateways.containsKey(gatewayName)) {
            return this._gateways.get(gatewayName);
        }
        return null;
    }

    @Override
    public String getPromotedReference() {
        return this._promotedReference;
    }

    @Override
    public String getInterface() {
        return this._referenceInterface;
    }

    @Override
    public QName getName() {
        return this._name;
    }

    @Override
    public List<ServiceOperation> getServiceOperations() {
        return Collections.unmodifiableList(this._operations);
    }

    @Override
    public ServiceOperation getServiceOperation(String operation) {
        for (ServiceOperation serviceOperation : this._operations) {
            if (!serviceOperation.getName().equals(operation)) continue;
            return serviceOperation;
        }
        return null;
    }

    @Override
    public void resetMessageMetrics() {
        for (Binding binding : this._gateways.values()) {
            binding.resetMessageMetrics();
        }
        for (ServiceOperation operation : this._operations) {
            operation.resetMessageMetrics();
        }
        super.resetMessageMetrics();
    }

    @Override
    public void recordMetrics(Exchange exchange) {
        String operationName;
        String gatewayName = (String)exchange.getContext().getPropertyValue("org.switchyard.exchangeGatewayName");
        if (gatewayName != null && this._gateways.containsKey(gatewayName)) {
            this._gateways.get(gatewayName).recordMetrics(exchange);
        }
        if ((operationName = exchange.getContract().getProviderOperation().getName()) != null) {
            for (ServiceOperation operation : this._operations) {
                if (!operationName.equals(operation.getName())) continue;
                operation.recordMetrics(exchange);
                break;
            }
        }
        super.recordMetrics(exchange);
    }
}

