/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.io.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.switchyard.common.io.resource.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ElementResource
extends Resource<Element> {
    @Override
    public Element pull(InputStream is) throws IOException {
        return this.pull(new InputSource(is));
    }

    public Element pull(Reader reader) throws IOException {
        return this.pull(new InputSource(reader));
    }

    public Element pull(InputSource is) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            return this.pull(factory.newDocumentBuilder().parse(is));
        }
        catch (ParserConfigurationException pce) {
            throw new IOException(pce);
        }
        catch (SAXException se) {
            throw new IOException(se);
        }
    }

    public Element pull(Document document) {
        return this.pull(document.getDocumentElement());
    }

    public Element pull(Element element) {
        return this.pull(element, true);
    }

    public Element pull(Element element, boolean normalize) {
        if (normalize) {
            element.normalize();
        }
        return element;
    }

    public Element pull(QName qname) {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        String prefix = qname.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            sb.append(prefix);
            sb.append(':');
        }
        sb.append(qname.getLocalPart());
        String namespace = qname.getNamespaceURI();
        if (namespace != null && namespace.length() > 0) {
            sb.append(" xmlns");
            if (prefix != null && prefix.length() > 0) {
                sb.append(':');
                sb.append(prefix);
            }
            sb.append("=\"");
            sb.append(namespace);
            sb.append('\"');
        }
        sb.append("/>");
        try {
            return this.pull(new StringReader(sb.toString()));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

