/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.switchyard.common.xml.IdentitySAXHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLHelper {
    private static final Logger LOGGER = Logger.getLogger(XMLHelper.class);
    private static final XMLInputFactory XML_INPUT_FACTORY;
    private static final XMLOutputFactory XML_OUTPUT_FACTORY;
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY;
    private static final AtomicReference<DocumentBuilder> DOCUMENT_BUILDER;
    private static final EventWriterCreator EVENT_WRITER_CREATOR;
    private static final EventReaderCreator EVENT_READER_CREATOR;

    private XMLHelper() {
    }

    public static XMLStreamReader getXMLStreamReader(Reader reader) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLStreamReader(reader);
    }

    public static XMLStreamReader getXMLStreamReader(InputStream is) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLStreamReader(is);
    }

    public static XMLStreamReader getXMLStreamReader(InputStream is, String encoding) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLStreamReader(is, encoding);
    }

    public static XMLStreamReader getXMLStreamReader(Source source) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLStreamReader(source);
    }

    public static XMLEventReader getXMLEventReader(Reader reader) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLEventReader(reader);
    }

    public static XMLEventReader getXMLEventReader(InputStream is) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLEventReader(is);
    }

    public static XMLEventReader getXMLEventReader(InputStream is, String encoding) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLEventReader(is, encoding);
    }

    public static XMLEventReader getXMLEventReader(Source source) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLEventReader(source);
    }

    public static XMLStreamWriter getXMLStreamWriter(Writer writer) throws XMLStreamException {
        return XML_OUTPUT_FACTORY.createXMLStreamWriter(writer);
    }

    public static XMLStreamWriter getXMLStreamWriter(OutputStream os) throws XMLStreamException {
        return XML_OUTPUT_FACTORY.createXMLStreamWriter(os);
    }

    public static XMLStreamWriter getXMLStreamWriter(OutputStream os, String encoding) throws XMLStreamException {
        return XML_OUTPUT_FACTORY.createXMLStreamWriter(os, encoding);
    }

    public static XMLStreamWriter getXMLStreamWriter(Result result) throws XMLStreamException {
        return XML_OUTPUT_FACTORY.createXMLStreamWriter(result);
    }

    public static XMLEventWriter getXMLEventWriter(Writer writer) throws XMLStreamException {
        return XML_OUTPUT_FACTORY.createXMLEventWriter(writer);
    }

    public static XMLEventWriter getXMLEventWriter(OutputStream os) throws XMLStreamException {
        return XML_OUTPUT_FACTORY.createXMLEventWriter(os);
    }

    public static XMLEventWriter getXMLEventWriter(OutputStream os, String encoding) throws XMLStreamException {
        return XML_OUTPUT_FACTORY.createXMLEventWriter(os, encoding);
    }

    public static XMLEventWriter getXMLEventWriter(Result result) throws XMLStreamException {
        return XML_OUTPUT_FACTORY.createXMLEventWriter(result);
    }

    public static void copyXMLEventStream(XMLEventReader reader, XMLEventWriter writer) throws XMLStreamException {
        XMLHelper.copyXMLEventStream(reader, writer, false);
    }

    public static void copyXMLEventStream(XMLEventReader reader, XMLEventWriter writer, boolean omitDoc) throws XMLStreamException {
        if (omitDoc) {
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                int type = event.getEventType();
                if (type == 7 || type == 8) continue;
                writer.add(event);
            }
        } else {
            writer.add(reader);
        }
        writer.flush();
    }

    public static boolean validate(Schema schema, String xml) {
        Validator validator = schema.newValidator();
        try {
            validator.validate(new StreamSource(new StringReader(xml)));
            return true;
        }
        catch (IOException ioe) {
            LOGGER.debug((Object)ioe.getMessage(), (Throwable)ioe);
        }
        catch (SAXException saxe) {
            LOGGER.debug((Object)saxe.getMessage(), (Throwable)saxe);
        }
        return false;
    }

    public static boolean compareXMLContent(InputStream content1, InputStream content2) throws ParserConfigurationException, SAXException, IOException {
        return XMLHelper.compareXMLContent(new InputSource(content1), new InputSource(content2));
    }

    public static boolean compareXMLContent(String content1, String content2) throws ParserConfigurationException, SAXException, IOException {
        return XMLHelper.compareXMLContent(new StringReader(content1), new StringReader(content2));
    }

    public static boolean compareXMLContent(Reader content1, Reader content2) throws ParserConfigurationException, SAXException, IOException {
        return XMLHelper.compareXMLContent(new InputSource(content1), new InputSource(content2));
    }

    public static boolean compareXMLContent(InputSource content1, InputSource content2) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        SAXParser parser = parserFactory.newSAXParser();
        IdentitySAXHandler handler1 = new IdentitySAXHandler();
        parser.parse(content1, (DefaultHandler)handler1);
        IdentitySAXHandler handler2 = new IdentitySAXHandler();
        parser.parse(content2, (DefaultHandler)handler2);
        return handler1.getRootElement().equals(handler2.getRootElement());
    }

    public static boolean compareXMLContent(Node node1, Node node2) throws ParserConfigurationException, TransformerException, SAXException, IOException {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        StringWriter writer1 = new StringWriter();
        StringWriter writer2 = new StringWriter();
        DOMSource source = new DOMSource(node1);
        StreamResult result = new StreamResult(writer1);
        transformer.transform(source, result);
        source = new DOMSource(node2);
        result = new StreamResult(writer2);
        transformer.transform(source, result);
        return XMLHelper.compareXMLContent(writer1.toString(), writer2.toString());
    }

    public static Document createDocument(XMLEventReader reader) throws ParserConfigurationException, XMLStreamException {
        Document doc = XMLHelper.getNewDocument();
        XMLEventWriter writer = EVENT_WRITER_CREATOR.createXMLEventWriter(doc);
        XMLHelper.copyXMLEventStream(reader, writer);
        return doc;
    }

    public static void readDomNode(Node node, XMLEventWriter writer, boolean omitDoc) throws XMLStreamException {
        XMLEventReader reader = EVENT_READER_CREATOR.createXMLEventReader(node);
        XMLHelper.copyXMLEventStream(reader, writer, omitDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document getNewDocument() throws ParserConfigurationException {
        DocumentBuilder builder;
        DocumentBuilder documentBuilder = builder = XMLHelper.getCreationDocumentBuilder();
        synchronized (documentBuilder) {
            return builder.newDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocument(InputSource source) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder;
        DocumentBuilder documentBuilder = builder = XMLHelper.getCreationDocumentBuilder();
        synchronized (documentBuilder) {
            return builder.parse(source);
        }
    }

    public static String toString(Node node) throws ParserConfigurationException, TransformerException {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        StringWriter writer = new StringWriter();
        DOMSource source = new DOMSource(node);
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        return writer.toString();
    }

    public static Element getFirstChildElementByName(Node node, String name) {
        NodeList children = node.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1 || child.getNodeName() == null || !child.getNodeName().equals(name)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getFirstChildElement(Node node) {
        NodeList children = node.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getNextSiblingElement(Node node) {
        Node sibling;
        for (sibling = node.getNextSibling(); sibling != null && sibling.getNodeType() != 1; sibling = sibling.getNextSibling()) {
        }
        return (Element)sibling;
    }

    private static DocumentBuilder getCreationDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilder current = DOCUMENT_BUILDER.get();
        if (current != null) {
            return current;
        }
        DocumentBuilder newBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
        if (DOCUMENT_BUILDER.compareAndSet(null, newBuilder)) {
            return newBuilder;
        }
        return DOCUMENT_BUILDER.get();
    }

    public static String nameOf(Node node) {
        if (node != null) {
            String name = node.getLocalName();
            if (name == null || name.length() == 0) {
                name = node.getNodeName();
            }
            return name;
        }
        return null;
    }

    public static QName createQName(Document document) {
        return XMLHelper.createQName(document.getDocumentElement());
    }

    public static QName createQName(Element element) {
        return XMLHelper.createQName(element.getNamespaceURI(), XMLHelper.nameOf(element), element.getPrefix());
    }

    public static QName createQName(String name) {
        if (name != null) {
            return QName.valueOf(name);
        }
        return null;
    }

    public static QName createQName(String namespace, String localName) {
        return XMLHelper.createQName(namespace, localName, null);
    }

    public static QName createQName(String namespace, String localName, String prefix) {
        if (namespace != null && namespace.length() > 0) {
            if (prefix != null && prefix.length() > 0) {
                return new QName(namespace, localName, prefix);
            }
            return new QName(namespace, localName);
        }
        return XMLHelper.createQName(localName);
    }

    static {
        DOCUMENT_BUILDER = new AtomicReference();
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        XML_INPUT_FACTORY = xmlInputFactory;
        EVENT_READER_CREATOR = new DefaultEventReaderCreator();
        XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
        EVENT_WRITER_CREATOR = new DefaultEventWriterCreator();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        DOCUMENT_BUILDER_FACTORY = docBuilderFactory;
    }

    private static final class DefaultEventReaderCreator
    implements EventReaderCreator {
        private DefaultEventReaderCreator() {
        }

        @Override
        public XMLEventReader createXMLEventReader(Node node) throws XMLStreamException {
            return XMLHelper.getXMLEventReader(new DOMSource(node));
        }
    }

    private static final class DefaultEventWriterCreator
    implements EventWriterCreator {
        private DefaultEventWriterCreator() {
        }

        @Override
        public XMLEventWriter createXMLEventWriter(Document doc) throws XMLStreamException {
            return XMLHelper.getXMLEventWriter(new DOMResult(doc));
        }
    }

    private static interface EventReaderCreator {
        public XMLEventReader createXMLEventReader(Node var1) throws XMLStreamException;
    }

    private static interface EventWriterCreator {
        public XMLEventWriter createXMLEventWriter(Document var1) throws XMLStreamException;
    }
}

