/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.switchyard.internal.io.Serializer;

public abstract class BaseSerializer
implements Serializer {
    private boolean _closeEnabled = false;

    @Override
    public <T> byte[] serialize(T obj, Class<T> type) throws IOException {
        return this.serialize(obj, type, 256);
    }

    @Override
    public <T> byte[] serialize(T obj, Class<T> type, int bufferSize) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(bufferSize);
        int count = this.serialize(obj, type, out, bufferSize);
        byte[] bytes = out.toByteArray();
        assert (count == bytes.length);
        return bytes;
    }

    @Override
    public <T> int serialize(T obj, Class<T> type, OutputStream out) throws IOException {
        return this.serialize(obj, type, out, 256);
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> type) throws IOException {
        return this.deserialize(bytes, type, 256);
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> type, int bufferSize) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return this.deserialize(in, type, bufferSize);
    }

    @Override
    public <T> T deserialize(InputStream in, Class<T> type) throws IOException {
        return this.deserialize(in, type, 256);
    }

    @Override
    public boolean isCloseEnabled() {
        return this._closeEnabled;
    }

    @Override
    public Serializer setCloseEnabled(boolean closeEnabled) {
        this._closeEnabled = closeEnabled;
        return this;
    }
}

