/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.switchyard.internal.io.BaseSerializer;
import org.switchyard.internal.io.Serializer;
import org.switchyard.internal.io.graph.Graph;
import org.switchyard.internal.io.graph.GraphBuilder;
import org.switchyard.internal.io.graph.GraphWrapper;

public final class GraphSerializer
extends BaseSerializer {
    private final Serializer _serializer;

    public GraphSerializer(Serializer serializer) {
        this._serializer = serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int serialize(T obj, Class<T> type, OutputStream out, int bufferSize) throws IOException {
        Graph<T> graph = GraphBuilder.build(obj);
        GraphWrapper<T> wrapper = graph instanceof GraphWrapper ? (GraphWrapper<T>)graph : GraphWrapper.wrap(graph);
        try {
            int n = this._serializer.serialize(wrapper, GraphWrapper.class, out, bufferSize);
            return n;
        }
        finally {
            if (this.isCloseEnabled()) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(InputStream in, Class<T> type, int bufferSize) throws IOException {
        try {
            GraphWrapper wrapper = this._serializer.deserialize(in, GraphWrapper.class, bufferSize);
            Object t = wrapper.decompose(null);
            return t;
        }
        finally {
            if (this.isCloseEnabled()) {
                in.close();
            }
        }
    }
}

