/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.config.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.transform.TransformModel;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.transform.BaseTransformer;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.config.model.JSONTransformModel;
import org.switchyard.transform.config.model.JavaTransformModel;
import org.switchyard.transform.config.model.SmooksTransformModel;
import org.switchyard.transform.config.model.TransformerTypes;
import org.switchyard.transform.json.internal.JSONTransformFactory;
import org.switchyard.transform.smooks.internal.SmooksTransformFactory;

public final class TransformerFactory {
    private static final QName OBJECT_TYPE = JavaService.toMessageType(Object.class);

    private TransformerFactory() {
    }

    public static Transformer<?, ?> newTransformer(TransformModel transformModel) {
        return TransformerFactory.newTransformers(transformModel).iterator().next();
    }

    public static Collection<Transformer<?, ?>> newTransformers(TransformModel transformModel) {
        Collection<Transformer<?, ?>> transformers = null;
        if (transformModel instanceof JavaTransformModel) {
            String className = ((JavaTransformModel)transformModel).getClazz();
            try {
                Class transformClass = Classes.forName((String)className, TransformerFactory.class);
                transformers = TransformerFactory.newTransformers(transformClass, transformModel.getFrom(), transformModel.getTo());
            }
            catch (Exception e) {
                throw new SwitchYardException("Error constructing Transformer instance for class '" + className + "'.", (Throwable)e);
            }
        } else if (transformModel instanceof SmooksTransformModel) {
            transformers = new ArrayList();
            transformers.add(SmooksTransformFactory.newTransformer((SmooksTransformModel)transformModel));
        } else if (transformModel instanceof JSONTransformModel) {
            transformers = new ArrayList();
            transformers.add(JSONTransformFactory.newTransformer((JSONTransformModel)transformModel));
        }
        if (transformers == null || transformers.isEmpty()) {
            throw new SwitchYardException("Unknown TransformModel type '" + transformModel.getClass().getName() + "'.");
        }
        return transformers;
    }

    public static Transformer<?, ?> newTransformer(Class<?> clazz, QName from, QName to) {
        return TransformerFactory.newTransformers(clazz, from, to).iterator().next();
    }

    public static Collection<Transformer<?, ?>> newTransformers(Class<?> clazz, QName from, QName to) {
        Method[] publicMethods;
        Object transformerObject;
        if (!TransformerFactory.isTransformer(clazz)) {
            throw new SwitchYardException("Invalid Transformer class '" + clazz.getName() + "'.  Must implement the Transformer interface, or have methods annotated with the @Transformer annotation.");
        }
        boolean fromIsWild = TransformerFactory.isWildcardType(from);
        boolean toIsWild = TransformerFactory.isWildcardType(to);
        ArrayList transformers = new ArrayList();
        try {
            transformerObject = clazz.newInstance();
        }
        catch (Exception e) {
            throw new SwitchYardException("Error constructing Transformer instance for class '" + clazz.getName() + "'.  Class must have a public default constructor.", (Throwable)e);
        }
        for (Method publicMethod : publicMethods = clazz.getMethods()) {
            org.switchyard.annotations.Transformer transformerAnno = publicMethod.getAnnotation(org.switchyard.annotations.Transformer.class);
            if (transformerAnno == null) continue;
            TransformerMethod transformerMethod = TransformerFactory.toTransformerMethod(publicMethod, transformerAnno);
            if (!fromIsWild && !transformerMethod.getFrom().equals(from) || !toIsWild && !transformerMethod.getTo().equals(to)) continue;
            transformers.add(TransformerFactory.newTransformer(transformerObject, transformerMethod.getMethod(), transformerMethod.getFrom(), transformerMethod.getTo()));
        }
        if (transformerObject instanceof Transformer) {
            Transformer transformer = (Transformer)transformerObject;
            QName transFrom = transformer.getFrom();
            QName transTo = transformer.getTo();
            if (transFrom.equals(OBJECT_TYPE) && transTo.equals(OBJECT_TYPE)) {
                transformers.add(transformer);
            } else if ((fromIsWild || transFrom.equals(from)) && (toIsWild || transTo.equals(to))) {
                transformers.add(transformer);
            } else if (TransformerFactory.isAssignableFrom(transFrom, from) && TransformerFactory.isAssignableFrom(transTo, to)) {
                transformers.add(transformer);
            }
            if (!fromIsWild) {
                transformer.setFrom(from);
            }
            if (!toIsWild) {
                transformer.setTo(to);
            }
        }
        if (transformers.isEmpty()) {
            throw new SwitchYardException("Error constructing Transformer instance for class '" + clazz.getName() + "'.  Class does not support a transformation from type '" + from + "' to type '" + to + "'.");
        }
        return transformers;
    }

    public static List<TransformerTypes> listTransformations(Class<?> clazz) {
        Method[] publicMethods;
        Object transformerObject;
        ArrayList<TransformerTypes> transformations = new ArrayList<TransformerTypes>();
        try {
            transformerObject = clazz.newInstance();
        }
        catch (Exception e) {
            throw new SwitchYardException("Error constructing Transformer instance for class '" + clazz.getName() + "'.  Class must have a public default constructor.", (Throwable)e);
        }
        if (transformerObject instanceof Transformer) {
            QName from = ((Transformer)transformerObject).getFrom();
            QName to = ((Transformer)transformerObject).getTo();
            if (from != null && to != null) {
                transformations.add(new TransformerTypes(from, to));
            }
        }
        for (Method publicMethod : publicMethods = clazz.getMethods()) {
            org.switchyard.annotations.Transformer transformerAnno = publicMethod.getAnnotation(org.switchyard.annotations.Transformer.class);
            if (transformerAnno == null) continue;
            TransformerMethod transformerMethod = TransformerFactory.toTransformerMethod(publicMethod, transformerAnno);
            transformations.add(new TransformerTypes(transformerMethod.getFrom(), transformerMethod.getTo()));
        }
        return transformations;
    }

    public static boolean isTransformer(Class<?> clazz) {
        Method[] publicMethods;
        if (clazz.isInterface()) {
            return false;
        }
        if (clazz.isAnnotation()) {
            return false;
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return false;
        }
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        if (Transformer.class.isAssignableFrom(clazz)) {
            return true;
        }
        for (Method publicMethod : publicMethods = clazz.getMethods()) {
            if (!publicMethod.isAnnotationPresent(org.switchyard.annotations.Transformer.class)) continue;
            return true;
        }
        return false;
    }

    private static Transformer newTransformer(Object transformerObject, Method publicMethod, org.switchyard.annotations.Transformer transformerAnno) {
        Class<?>[] params = publicMethod.getParameterTypes();
        if (params.length != 1) {
            throw new SwitchYardException("Invalid @Transformer method '" + publicMethod.getName() + "' on class '" + publicMethod.getDeclaringClass().getName() + "'.  Must have exactly 1 parameter.");
        }
        Class<?> fromType = params[0];
        Class<?> toType = publicMethod.getReturnType();
        if (toType == null) {
            throw new SwitchYardException("Invalid @Transformer method '" + publicMethod.getName() + "' on class '" + publicMethod.getDeclaringClass().getName() + "'.  Must return a result.");
        }
        QName from = !transformerAnno.from().trim().equals("") ? QName.valueOf(transformerAnno.from().trim()) : JavaService.toMessageType(fromType);
        QName to = !transformerAnno.to().trim().equals("") ? QName.valueOf(transformerAnno.to().trim()) : JavaService.toMessageType(toType);
        return TransformerFactory.newTransformer(transformerObject, publicMethod, from, to);
    }

    private static Transformer newTransformer(final Object transformerObject, final Method publicMethod, QName from, QName to) {
        BaseTransformer transformer = new BaseTransformer(){

            public Object transform(Object from) {
                try {
                    return publicMethod.invoke(transformerObject, from);
                }
                catch (InvocationTargetException e) {
                    throw new SwitchYardException("Error executing @Transformer method '" + publicMethod.getName() + "' on class '" + publicMethod.getDeclaringClass().getName() + "'.", e.getCause());
                }
                catch (Exception e) {
                    throw new SwitchYardException("Error executing @Transformer method '" + publicMethod.getName() + "' on class '" + publicMethod.getDeclaringClass().getName() + "'.", (Throwable)e);
                }
            }
        };
        transformer.setFrom(from);
        transformer.setTo(to);
        return transformer;
    }

    private static boolean isAssignableFrom(QName a, QName b) {
        if (JavaService.isJavaMessageType((QName)a) && JavaService.isJavaMessageType((QName)b)) {
            Class aType = JavaService.toJavaMessageType((QName)a);
            Class bType = JavaService.toJavaMessageType((QName)b);
            if (aType == null || bType == null) {
                return false;
            }
            return aType.isAssignableFrom(bType);
        }
        return false;
    }

    private static boolean isWildcardType(QName type) {
        return type.toString().equals("*");
    }

    private static TransformerMethod toTransformerMethod(Method publicMethod, org.switchyard.annotations.Transformer transformerAnno) {
        Class<?>[] params = publicMethod.getParameterTypes();
        if (params.length != 1) {
            throw new SwitchYardException("Invalid @Transformer method '" + publicMethod.getName() + "' on class '" + publicMethod.getDeclaringClass().getName() + "'.  Must have exactly 1 parameter.");
        }
        Class<?> fromType = params[0];
        Class<?> toType = publicMethod.getReturnType();
        if (toType == null) {
            throw new SwitchYardException("Invalid @Transformer method '" + publicMethod.getName() + "' on class '" + publicMethod.getDeclaringClass().getName() + "'.  Must return a result.");
        }
        QName from = !transformerAnno.from().trim().equals("") ? QName.valueOf(transformerAnno.from().trim()) : JavaService.toMessageType(fromType);
        QName to = !transformerAnno.to().trim().equals("") ? QName.valueOf(transformerAnno.to().trim()) : JavaService.toMessageType(toType);
        return new TransformerMethod(from, to, publicMethod);
    }

    private static class TransformerMethod
    extends TransformerTypes {
        private Method _method;

        TransformerMethod(QName from, QName to, Method publicMethod) {
            super(from, to);
            this._method = publicMethod;
        }

        private Method getMethod() {
            return this._method;
        }
    }
}

