/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Stack;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.Configurator;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.java.JavaXMLReader;
import org.milyn.delivery.java.XStreamXMLReader;
import org.milyn.io.NullReader;
import org.milyn.io.NullWriter;
import org.milyn.payload.FilterSource;
import org.milyn.payload.JavaSource;
import org.milyn.util.ClassUtil;
import org.milyn.xml.NullSourceXMLReader;
import org.milyn.xml.SmooksXMLReader;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractParser {
    private static Log logger = LogFactory.getLog(AbstractParser.class);
    private ExecutionContext execContext;
    private SmooksResourceConfiguration saxDriverConfig;
    public static final String ORG_XML_SAX_DRIVER = "org.xml.sax.driver";
    public static final String FEATURE_ON = "feature-on";
    public static final String FEATURE_OFF = "feature-off";

    public AbstractParser(ExecutionContext execContext, SmooksResourceConfiguration saxDriverConfig) {
        AssertArgument.isNotNull(execContext, "execContext");
        this.execContext = execContext;
        this.saxDriverConfig = saxDriverConfig;
    }

    public AbstractParser(ExecutionContext execContext) {
        this(execContext, AbstractParser.getSAXParserConfiguration(execContext.getDeliveryConfig()));
    }

    protected ExecutionContext getExecContext() {
        return this.execContext;
    }

    protected SmooksResourceConfiguration getSaxDriverConfig() {
        return this.saxDriverConfig;
    }

    public static void attachXMLReader(XMLReader xmlReader, ExecutionContext execContext) {
        AbstractParser.getReaders(execContext).push(xmlReader);
    }

    public static XMLReader getXMLReader(ExecutionContext execContext) {
        Stack<XMLReader> xmlReaderStack = AbstractParser.getReaders(execContext);
        if (!xmlReaderStack.isEmpty()) {
            return xmlReaderStack.peek();
        }
        return null;
    }

    public static void detachXMLReader(ExecutionContext execContext) {
        Stack<XMLReader> xmlReaderStack = AbstractParser.getReaders(execContext);
        if (!xmlReaderStack.isEmpty()) {
            xmlReaderStack.pop();
        }
    }

    private static Stack<XMLReader> getReaders(ExecutionContext execContext) {
        Stack readers = (Stack)execContext.getAttribute(XMLReader.class);
        if (readers == null) {
            readers = new Stack();
            execContext.setAttribute(XMLReader.class, readers);
        }
        return readers;
    }

    public static SmooksResourceConfiguration getSAXParserConfiguration(ContentDeliveryConfig deliveryConfig) {
        if (deliveryConfig == null) {
            throw new IllegalArgumentException("null 'deliveryConfig' arg in method call.");
        }
        SmooksResourceConfiguration saxDriverConfig = null;
        List<SmooksResourceConfiguration> saxConfigs = deliveryConfig.getSmooksResourceConfigurations(ORG_XML_SAX_DRIVER);
        if (saxConfigs != null && !saxConfigs.isEmpty()) {
            saxDriverConfig = saxConfigs.get(0);
        }
        return saxDriverConfig;
    }

    protected static Reader getReader(Source source, String contentEncoding) {
        if (source != null) {
            if (source instanceof StreamSource) {
                StreamSource streamSource = (StreamSource)source;
                if (streamSource.getReader() != null) {
                    return streamSource.getReader();
                }
                if (streamSource.getInputStream() != null) {
                    return AbstractParser.streamToReader(streamSource.getInputStream(), contentEncoding);
                }
                if (streamSource.getSystemId() != null) {
                    return AbstractParser.systemIdToReader(streamSource.getSystemId(), contentEncoding);
                }
                throw new SmooksException("Invalid " + StreamSource.class.getName() + ".  No InputStream, Reader or SystemId instance.");
            }
            if (source.getSystemId() != null) {
                return AbstractParser.systemIdToReader(source.getSystemId(), contentEncoding);
            }
        }
        return new NullReader();
    }

    private static Reader systemIdToReader(String systemId, String contentEncoding) {
        return AbstractParser.streamToReader(AbstractParser.systemIdToStream(systemId), contentEncoding);
    }

    private static InputStream systemIdToStream(String systemId) {
        try {
            return AbstractParser.systemIdToURL(systemId).openStream();
        }
        catch (IOException e) {
            throw new SmooksException("Invalid System ID on StreamSource: '" + systemId + "'.  Unable to open stream to resource.", e);
        }
    }

    private static URL systemIdToURL(String systemId) {
        try {
            return new URL(systemId);
        }
        catch (MalformedURLException e) {
            throw new SmooksException("Invalid System ID on StreamSource: '" + systemId + "'.  Must be a valid URL.", e);
        }
    }

    private static Reader streamToReader(InputStream inputStream, String contentEncoding) {
        try {
            if (contentEncoding != null) {
                return new InputStreamReader(inputStream, contentEncoding);
            }
            return new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SmooksException("Unable to decode input stream.", e);
        }
    }

    protected InputSource createInputSource(Source source, String contentEncoding) {
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            InputStream inputStream = this.getInputStream(streamSource);
            Reader reader = streamSource.getReader();
            if (reader == null) {
                if (inputStream == null) {
                    throw new SmooksException("Invalid StreamSource.  Unable to extract an InputStream (even by systemId) or Reader instance.");
                }
                reader = AbstractParser.streamToReader(inputStream, contentEncoding);
            }
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(inputStream);
            inputSource.setCharacterStream(reader);
            return inputSource;
        }
        return new InputSource(AbstractParser.getReader(source, contentEncoding));
    }

    protected InputStream getInputStream(StreamSource streamSource) {
        InputStream inputStream = streamSource.getInputStream();
        String systemId = streamSource.getSystemId();
        if (inputStream != null) {
            return inputStream;
        }
        if (systemId != null) {
            return AbstractParser.systemIdToStream(systemId);
        }
        return null;
    }

    protected Writer getWriter(Result result, ExecutionContext executionContext) {
        if (!(result instanceof StreamResult)) {
            return new NullWriter();
        }
        StreamResult streamResult = (StreamResult)result;
        if (streamResult.getWriter() != null) {
            return streamResult.getWriter();
        }
        if (streamResult.getOutputStream() != null) {
            try {
                if (executionContext != null) {
                    return new OutputStreamWriter(streamResult.getOutputStream(), executionContext.getContentEncoding());
                }
                return new OutputStreamWriter(streamResult.getOutputStream(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SmooksException("Unable to encode output stream.", e);
            }
        }
        throw new SmooksException("Invalid " + StreamResult.class.getName() + ".  No OutputStream or Writer instance.");
    }

    protected XMLReader createXMLReader() throws SAXException {
        XMLReader reader;
        ExecutionContext execContext = this.getExecContext();
        Source source = FilterSource.getSource(execContext);
        if (this.saxDriverConfig != null && this.saxDriverConfig.getResource() != null) {
            String className = this.saxDriverConfig.getResource();
            reader = XMLReaderFactory.createXMLReader(className);
        } else if (source instanceof JavaSource) {
            boolean eventStreamingOn;
            JavaSource javaSource = (JavaSource)source;
            if (AbstractParser.isFeatureOn("http://www.smooks.org/sax/features/generate-java-event-stream", this.saxDriverConfig) && !javaSource.isEventStreamRequired()) {
                throw new SAXException("Invalid Smooks configuration.  Feature 'http://www.smooks.org/sax/features/generate-java-event-stream' is explicitly configured 'on' in the Smooks configuration, while the supplied JavaSource has explicitly configured event streaming to be off (through a call to JavaSource.setEventStreamRequired).");
            }
            boolean bl = eventStreamingOn = !AbstractParser.isFeatureOff("http://www.smooks.org/sax/features/generate-java-event-stream", this.saxDriverConfig) && javaSource.isEventStreamRequired();
            reader = eventStreamingOn && javaSource.getSourceObjects() != null ? new XStreamXMLReader() : new NullSourceXMLReader();
        } else {
            reader = XMLReaderFactory.createXMLReader();
        }
        if (reader instanceof SmooksXMLReader) {
            if (this.saxDriverConfig != null) {
                Configurator.configure(reader, this.saxDriverConfig, execContext.getContext());
            } else {
                Configurator.initialise(reader);
            }
        }
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        this.setHandlers(reader);
        this.setFeatures(reader);
        return reader;
    }

    protected void configureReader(XMLReader reader, DefaultHandler2 handler, ExecutionContext execContext, Source source) throws SAXException {
        if (reader instanceof SmooksXMLReader) {
            ((SmooksXMLReader)reader).setExecutionContext(execContext);
        }
        if (reader instanceof JavaXMLReader) {
            if (!(source instanceof JavaSource)) {
                throw new SAXException("A " + JavaSource.class.getName() + " source must be supplied for " + JavaXMLReader.class.getName() + " implementations.");
            }
            ((JavaXMLReader)reader).setSourceObjects(((JavaSource)source).getSourceObjects());
        }
        reader.setContentHandler(handler);
        try {
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        }
        catch (SAXNotRecognizedException e) {
            logger.debug((Object)("XMLReader property 'http://xml.org/sax/properties/lexical-handler' not recognized by XMLReader '" + reader.getClass().getName() + "'."));
        }
    }

    private void setHandlers(XMLReader reader) throws SAXException {
        List<Parameter> handlers;
        if (this.saxDriverConfig != null && (handlers = this.saxDriverConfig.getParameters("sax-handler")) != null) {
            for (Parameter handler : handlers) {
                Object handlerObj = this.createHandler(handler.getValue());
                if (handlerObj instanceof EntityResolver) {
                    reader.setEntityResolver((EntityResolver)handlerObj);
                }
                if (handlerObj instanceof DTDHandler) {
                    reader.setDTDHandler((DTDHandler)handlerObj);
                }
                if (!(handlerObj instanceof ErrorHandler)) continue;
                reader.setErrorHandler((ErrorHandler)handlerObj);
            }
        }
    }

    private Object createHandler(String handlerName) throws SAXException {
        try {
            Class handlerClass = ClassUtil.forName(handlerName, this.getClass());
            return handlerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new SAXException("Failed to create SAX Handler '" + handlerName + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new SAXException("Failed to create SAX Handler '" + handlerName + "'.", e);
        }
        catch (InstantiationException e) {
            throw new SAXException("Failed to create SAX Handler '" + handlerName + "'.", e);
        }
    }

    private void setFeatures(XMLReader reader) throws SAXNotSupportedException, SAXNotRecognizedException {
        try {
            reader.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            reader.setFeature("http://xml.org/sax/features/xmlns-uris", true);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (this.saxDriverConfig != null) {
            List<Parameter> features = this.saxDriverConfig.getParameters(FEATURE_ON);
            if (features != null) {
                for (Parameter feature : features) {
                    reader.setFeature(feature.getValue(), true);
                }
            }
            if ((features = this.saxDriverConfig.getParameters(FEATURE_OFF)) != null) {
                for (Parameter feature : features) {
                    reader.setFeature(feature.getValue(), false);
                }
            }
        }
    }

    public static boolean isFeatureOn(String name, SmooksResourceConfiguration saxDriverConfig) throws SAXException {
        boolean featureOn = AbstractParser.isFeature(name, FeatureValue.ON, saxDriverConfig);
        if (featureOn && AbstractParser.isFeature(name, FeatureValue.OFF, saxDriverConfig)) {
            throw new SAXException("Invalid Smooks configuration.  Feature '" + name + "' is explicitly configured 'on' and 'off'.  Must be one or the other!");
        }
        return featureOn;
    }

    public static boolean isFeatureOff(String name, SmooksResourceConfiguration saxDriverConfig) throws SAXException {
        boolean featureOff = AbstractParser.isFeature(name, FeatureValue.OFF, saxDriverConfig);
        if (featureOff && AbstractParser.isFeature(name, FeatureValue.ON, saxDriverConfig)) {
            throw new SAXException("Invalid Smooks configuration.  Feature '" + name + "' is explicitly configured 'on' and 'off'.  Must be one or the other!");
        }
        return featureOff;
    }

    private static boolean isFeature(String name, FeatureValue featureValue, SmooksResourceConfiguration saxDriverConfig) {
        List<Parameter> features;
        if (saxDriverConfig != null && (features = featureValue == FeatureValue.ON ? saxDriverConfig.getParameters(FEATURE_ON) : saxDriverConfig.getParameters(FEATURE_OFF)) != null) {
            for (Parameter feature : features) {
                if (!feature.getValue().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FeatureValue {
        ON,
        OFF;

    }
}

