/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.unedifact.handlers;

import java.io.IOException;
import org.milyn.edisax.BufferedSegmentReader;
import org.milyn.edisax.interchange.ControlBlockHandler;
import org.milyn.edisax.interchange.InterchangeContext;
import org.milyn.edisax.model.internal.Segment;
import org.xml.sax.SAXException;

public class UNGHandler
implements ControlBlockHandler {
    private Segment ungSegment;
    private Segment uneSegment;

    public UNGHandler(Segment ungSegment, Segment uneSegment) {
        this.ungSegment = ungSegment;
        this.uneSegment = uneSegment;
    }

    public void process(InterchangeContext interchangeContext) throws IOException, SAXException {
        BufferedSegmentReader segmentReader = interchangeContext.getSegmentReader();
        interchangeContext.getControlSegmentParser().startElement("group", this.ungSegment.getNamespace(), true);
        segmentReader.moveToNextSegment(false);
        interchangeContext.mapControlSegment(this.ungSegment, true);
        while (true) {
            String segCode;
            if ((segCode = segmentReader.peek(3, true)).equals("UNE")) break;
            ControlBlockHandler handler = interchangeContext.getControlBlockHandler(segCode);
            handler.process(interchangeContext);
        }
        segmentReader.moveToNextSegment(false);
        interchangeContext.mapControlSegment(this.uneSegment, true);
        interchangeContext.getControlSegmentParser().endElement("group", this.ungSegment.getNamespace(), true);
    }
}

