/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.namespace;

import java.util.Map;
import java.util.Properties;
import org.milyn.namespace.NamespaceResolver;

public class SimpleNamespaceResolver
implements NamespaceResolver {
    protected Properties namespacesByPrefix = new Properties();
    protected Properties namespacesByUri = new Properties();

    public SimpleNamespaceResolver addNamespace(String uri, String prefix) {
        String inUseUriPrefix = this.namespacesByUri.getProperty(uri);
        String inUsePrefixUri = this.namespacesByPrefix.getProperty(prefix);
        if (inUsePrefixUri != null) {
            if (inUsePrefixUri.equals(uri)) {
                return this;
            }
            throw new IllegalArgumentException("Namespace prefix '" + prefix + "' already defined for namespace uri '" + inUsePrefixUri + "'.  Cannot redefined for uri '" + uri + "'.");
        }
        if (inUseUriPrefix != null) {
            if (inUseUriPrefix.equals(prefix)) {
                return this;
            }
            throw new IllegalArgumentException("Namespace uri '" + uri + "' already defined for namespace prefix '" + inUseUriPrefix + "'.  Cannot redefine for prefix '" + prefix + "'.");
        }
        this.namespacesByPrefix.setProperty(prefix, uri);
        this.namespacesByUri.setProperty(uri, prefix);
        return this;
    }

    public String getPrefix(String uri) {
        return this.namespacesByUri.getProperty(uri);
    }

    public String getUri(String prefix) {
        return this.namespacesByPrefix.getProperty(prefix);
    }

    public NamespaceResolver clone() {
        SimpleNamespaceResolver clone = new SimpleNamespaceResolver();
        clone.namespacesByPrefix.putAll((Map<?, ?>)this.namespacesByPrefix);
        clone.namespacesByUri.putAll((Map<?, ?>)this.namespacesByUri);
        return clone;
    }
}

