/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.ootb.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Logger;
import org.switchyard.annotations.Transformer;
import org.switchyard.transform.ootb.io.ReaderTransforms;
import org.xml.sax.InputSource;

public class InputStreamTransforms {
    public static final InputStreamTransforms TRANSFORMER = new InputStreamTransforms();
    private static final Logger LOGGER = Logger.getLogger(ReaderTransforms.class);

    @Transformer
    public String toString(InputStream inStream) {
        return ReaderTransforms.TRANSFORMER.toString(new InputStreamReader(inStream));
    }

    @Transformer
    public Reader toReader(InputStream inStream) {
        return new StringReader(this.toString(inStream));
    }

    @Transformer
    public InputSource toInputSource(InputStream inStream) {
        byte[] bytes = this.toBytes(inStream);
        InputSource inputSource = new InputSource();
        inputSource.setByteStream(new ByteArrayInputStream(bytes));
        return inputSource;
    }

    @Transformer
    public Integer toInteger(InputStream inStream) {
        return Integer.parseInt(this.toString(inStream));
    }

    @Transformer
    public Long toLong(InputStream inStream) {
        return Long.parseLong(this.toString(inStream));
    }

    @Transformer
    public Short toShort(InputStream inStream) {
        return Short.parseShort(this.toString(inStream));
    }

    @Transformer
    public char[] toChars(InputStream inStream) {
        return this.toString(inStream).toCharArray();
    }

    @Transformer
    public Character toCharacter(InputStream inStream) {
        return Character.valueOf(this.toString(inStream).charAt(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transformer
    public byte[] toBytes(InputStream inStream) {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        try {
            int readCount;
            byte[] readBuffer = new byte[56];
            while ((readCount = inStream.read(readBuffer)) != -1) {
                byteBuffer.write(readBuffer, 0, readCount);
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Error reading from InputStream.", (Throwable)e);
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException e) {
                LOGGER.debug((Object)"Failed to close InputStream instance.", (Throwable)e);
            }
        }
        return byteBuffer.toByteArray();
    }

    @Transformer
    public Double toDouble(InputStream inStream) {
        return Double.parseDouble(this.toString(inStream));
    }

    @Transformer
    public Float toFloat(InputStream inStream) {
        return Float.valueOf(Float.parseFloat(this.toString(inStream)));
    }
}

