/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.ootb.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.switchyard.config.model.Scannable;
import org.switchyard.transform.ootb.xml.AbstractDOMTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@Scannable(value=false)
public class BasicDOMTransformer
extends AbstractDOMTransformer {
    private static final QName TYPE_DOCUMENT = BasicDOMTransformer.toMessageType(Document.class);
    private static final QName TYPE_ELEMENT = BasicDOMTransformer.toMessageType(Element.class);
    private static final QName TYPE_STRING = BasicDOMTransformer.toMessageType(String.class);
    private static final QName TYPE_CHAR_ARRAY = BasicDOMTransformer.toMessageType(char[].class);
    private static final QName TYPE_INPUTSOURCE = BasicDOMTransformer.toMessageType(InputSource.class);
    private static final QName TYPE_READER = BasicDOMTransformer.toMessageType(Reader.class);
    private static final QName TYPE_INPUTSTREAM = BasicDOMTransformer.toMessageType(InputStream.class);
    private static final QName TYPE_NODE = BasicDOMTransformer.toMessageType(Node.class);

    public Object transform(Object from) {
        if (from instanceof Node) {
            return this.transformFromDOMNode((Node)from);
        }
        if (from instanceof String) {
            return this.transformFromInputSource(new InputSource(new StringReader((String)from)));
        }
        if (from instanceof char[]) {
            return this.transformFromInputSource(new InputSource(new StringReader(new String((char[])from))));
        }
        if (from instanceof byte[]) {
            return this.transformFromInputSource(new InputSource(new ByteArrayInputStream((byte[])from)));
        }
        if (from instanceof Reader) {
            return this.transformFromInputSource(new InputSource((Reader)from));
        }
        if (from instanceof InputStream) {
            return this.transformFromInputSource(new InputSource((InputStream)from));
        }
        if (from instanceof InputSource) {
            return this.transformFromInputSource((InputSource)from);
        }
        if (from instanceof DOMSource) {
            return this.transformFromDOMSource((DOMSource)from);
        }
        return null;
    }

    private Object transformFromDOMNode(Node from) {
        if (this.getTo().equals(TYPE_DOCUMENT)) {
            return from.getOwnerDocument();
        }
        if (this.getTo().equals(TYPE_ELEMENT)) {
            if (from.getNodeType() == 1) {
                return from;
            }
            if (from.getNodeType() == 2) {
                return from.getParentNode();
            }
            if (from.getNodeType() == 9) {
                return ((Document)from).getDocumentElement();
            }
        }
        if (this.getTo().equals(TYPE_STRING)) {
            return BasicDOMTransformer.serialize(from);
        }
        if (this.getTo().equals(TYPE_CHAR_ARRAY)) {
            return BasicDOMTransformer.serialize(from).toCharArray();
        }
        if (this.getTo().equals(TYPE_INPUTSOURCE)) {
            return new InputSource(new StringReader(BasicDOMTransformer.serialize(from)));
        }
        if (this.getTo().equals(TYPE_READER)) {
            return new StringReader(BasicDOMTransformer.serialize(from));
        }
        if (this.getTo().equals(TYPE_INPUTSTREAM)) {
            return new ByteArrayInputStream(BasicDOMTransformer.serialize(from).getBytes());
        }
        return null;
    }

    private Object transformFromInputSource(InputSource from) {
        Document document = BasicDOMTransformer.parse(from);
        if (this.getTo().equals(TYPE_DOCUMENT)) {
            return document;
        }
        if (this.getTo().equals(TYPE_ELEMENT)) {
            return document.getDocumentElement();
        }
        if (this.getTo().equals(TYPE_NODE)) {
            return document.getDocumentElement();
        }
        return null;
    }

    private Object transformFromDOMSource(DOMSource source) {
        if (this.getTo().equals(TYPE_NODE)) {
            return source.getNode();
        }
        if (this.getTo().equals(TYPE_ELEMENT)) {
            return source.getNode() instanceof Element ? (Element)source.getNode() : null;
        }
        return null;
    }
}

