/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.xslt;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.switchyard.common.type.Classes;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerFactory;
import org.switchyard.transform.config.model.XsltTransformModel;
import org.switchyard.transform.xslt.XsltTransformer;

public final class XsltTransformFactory
implements TransformerFactory<XsltTransformModel> {
    @Override
    public Transformer newTransformer(XsltTransformModel model) {
        String xsltFileUri = model.getXsltFile();
        QName to = model.getTo();
        QName from = model.getFrom();
        if (xsltFileUri == null || xsltFileUri.equals("")) {
            throw new SwitchYardException("No xsl file has been defined. Check your transformer configuration.");
        }
        try {
            InputStream stylesheetStream = Classes.getResourceAsStream((String)xsltFileUri);
            if (stylesheetStream == null) {
                throw new SwitchYardException("Failed to load xsl file '" + xsltFileUri + "' from classpath.");
            }
            javax.xml.transform.TransformerFactory tFactory = javax.xml.transform.TransformerFactory.newInstance();
            Templates templates = tFactory.newTemplates(new StreamSource(stylesheetStream));
            return new XsltTransformer(from, to, templates);
        }
        catch (TransformerConfigurationException e) {
            throw new SwitchYardException("An unexpected error ocurred while creating the xslt transformer", (Throwable)e);
        }
        catch (IOException e) {
            throw new SwitchYardException("Unable to locate the xslt file " + model.getXsltFile(), (Throwable)e);
        }
    }
}

