/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.metadata.java;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.switchyard.annotations.DefaultType;
import org.switchyard.annotations.OperationTypes;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.BaseService;
import org.switchyard.metadata.InOnlyOperation;
import org.switchyard.metadata.InOutOperation;
import org.switchyard.metadata.ServiceOperation;

public final class JavaService
extends BaseService {
    public static final String TYPE = "java";
    private static final String TYPE_PREFIX = "java:";
    private Class<?> _serviceInterface;

    private JavaService(Set<ServiceOperation> operations, Class<?> serviceInterface) {
        super(operations, TYPE);
        this._serviceInterface = serviceInterface;
    }

    public static JavaService fromClass(Class<?> serviceInterface) {
        HashSet<ServiceOperation> ops = new HashSet<ServiceOperation>();
        for (Method m : serviceInterface.getDeclaredMethods()) {
            if (!Modifier.isPublic(m.getModifiers())) continue;
            Class<?>[] params = m.getParameterTypes();
            if (params.length != 1) {
                throw new RuntimeException("Service operations on a Java interface must have exactly one parameter.");
            }
            OperationTypeQNames operationTypeNames = new OperationTypeQNames(m);
            if (m.getReturnType().equals(Void.TYPE)) {
                ops.add(new InOnlyOperation(m.getName(), operationTypeNames.in()));
                continue;
            }
            ops.add(new InOutOperation(m.getName(), operationTypeNames.in(), operationTypeNames.out(), operationTypeNames.fault()));
        }
        return new JavaService(ops, serviceInterface);
    }

    public Class<?> getJavaInterface() {
        return this._serviceInterface;
    }

    public static QName toMessageType(Class<?> javaType) {
        return QName.valueOf(JavaService.toMessageTypeString(javaType));
    }

    public static String toMessageTypeString(Class<?> javaType) {
        DefaultType defaultType = javaType.getAnnotation(DefaultType.class);
        if (defaultType != null) {
            return defaultType.value();
        }
        if (javaType.isMemberClass()) {
            return TYPE_PREFIX + javaType.getName();
        }
        return TYPE_PREFIX + javaType.getCanonicalName();
    }

    private static final class OperationTypeQNames {
        private Method _operationMethod;
        private OperationTypes _methodTypeNames;

        private OperationTypeQNames(Method operationMethod) {
            this._operationMethod = operationMethod;
            this._methodTypeNames = operationMethod.getAnnotation(OperationTypes.class);
        }

        public QName in() {
            Class<?> inputType = this._operationMethod.getParameterTypes()[0];
            if (this._methodTypeNames != null && this._methodTypeNames.in().length() != 0) {
                return QName.valueOf(this._methodTypeNames.in());
            }
            return JavaService.toMessageType(inputType);
        }

        public QName out() {
            if (this._methodTypeNames != null && this._methodTypeNames.out().length() != 0) {
                return QName.valueOf(this._methodTypeNames.out());
            }
            return JavaService.toMessageType(this._operationMethod.getReturnType());
        }

        public QName fault() {
            Class<?>[] exceptions = this._operationMethod.getExceptionTypes();
            if (exceptions.length == 0) {
                return null;
            }
            if (exceptions.length > 1) {
                throw new SwitchYardException("Service operations on a Java interface can only throw one type of exception.");
            }
            if (this._methodTypeNames != null && this._methodTypeNames.fault().length() != 0) {
                return QName.valueOf(this._methodTypeNames.fault());
            }
            return JavaService.toMessageType(exceptions[0]);
        }
    }
}

