/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.ModelPuller;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.transform.TransformsModel;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.deploy.internal.Activation;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.extensions.wsdl.WSDLReaderException;
import org.switchyard.extensions.wsdl.WSDLService;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.java.JavaService;

public class Deployment
extends AbstractDeployment {
    private static final String JAVA_INTERFACE = "java";
    private static final String WSDL_INTERFACE = "wsdl";
    private static Logger _log = Logger.getLogger(Deployment.class);
    private Map<String, Activator> _activators = new HashMap<String, Activator>();
    private List<Activation> _services = new LinkedList<Activation>();
    private List<Activation> _serviceBindings = new LinkedList<Activation>();
    private List<Activation> _references = new LinkedList<Activation>();
    private List<Activation> _referenceBindings = new LinkedList<Activation>();

    public Deployment(InputStream configStream) throws IOException {
        super((SwitchYardModel)new ModelPuller().pull(configStream));
    }

    public Deployment(SwitchYardModel configModel) {
        super(configModel);
    }

    @Override
    protected void doInit() {
        _log.debug((Object)("Initializing deployment " + this.getName()));
        this.registerTransformers();
        this.createActivators();
    }

    @Override
    protected void doStart() {
        _log.debug((Object)("Starting deployment " + this.getName()));
        try {
            this.deployReferenceBindings();
            this.deployServices();
            this.deployReferences();
            this.deployServiceBindings();
            this.deployAutoRegisteredTransformers();
        }
        catch (RuntimeException e1) {
            _log.debug((Object)("Undeploying partially deployed artifacts of failed deployment " + this.getConfig().getQName()));
            try {
                this.stop();
            }
            catch (RuntimeException e2) {
                _log.debug((Object)("Failed to properly undeploy a partial/failed deployment " + this.getConfig().getQName()), (Throwable)e2);
            }
            throw e1;
        }
    }

    @Override
    protected void doStop() {
        _log.debug((Object)("Stopping deployment " + this.getName()));
        this.undeployServiceBindings();
        this.undeployServices();
        this.undeployReferences();
        this.undeployReferenceBindings();
        this.undeployAutoRegisteredTransformers();
    }

    @Override
    protected void doDestroy() {
        _log.debug((Object)("Destroying deployment " + this.getName()));
        this.destroyDomain();
        this._services.clear();
        this._serviceBindings.clear();
        this._references.clear();
        this._referenceBindings.clear();
        this.getTransformerRegistryLoader().unregisterTransformers();
    }

    public Activator findActivator(String type) throws SwitchYardException {
        if (this._activators.containsKey(type)) {
            return this._activators.get(type);
        }
        throw new SwitchYardException("Activator not found for type: " + type);
    }

    private Activator findActivator(ComponentModel component) throws SwitchYardException {
        if (component.getImplementation() == null) {
            throw new SwitchYardException("Component defintion " + component.getName() + " does not included an implementation definition.");
        }
        return this.findActivator(component.getImplementation().getType());
    }

    private void createActivators() {
        ServiceDomain serviceDomain = this.getDomain();
        ServiceLoader<Activator> activatorLoader = ServiceLoader.load(Activator.class);
        for (Activator activator : activatorLoader) {
            activator.setServiceDomain(serviceDomain);
            Collection<String> activationTypes = activator.getActivationTypes();
            if (activationTypes == null) continue;
            for (String type : activationTypes) {
                _log.debug((Object)("Registered activation type " + type + " for activator " + activator.getClass() + " on deployment " + this.getName()));
                this._activators.put(type, activator);
            }
        }
    }

    private void registerTransformers() {
        _log.debug((Object)("Registering configured Transformers for deployment " + this.getName()));
        TransformsModel transforms = this.getConfig().getTransforms();
        this.getTransformerRegistryLoader().registerTransformers(transforms);
        this.fireTransformersRegistered(transforms);
    }

    private void deployReferenceBindings() {
        _log.debug((Object)("Deploying reference bindings for deployment " + this.getName()));
        for (CompositeReferenceModel reference : this.getConfig().getComposite().getReferences()) {
            for (BindingModel binding : reference.getBindings()) {
                QName refQName = reference.getQName();
                _log.debug((Object)("Deploying binding " + binding.getType() + " for reference " + reference.getQName() + " for deployment " + this.getName()));
                Activator activator = this.findActivator(binding.getType());
                ExchangeHandler handler = activator.init(refQName, (Model)reference);
                ServiceInterface si = this.getReferenceInterface(reference);
                ServiceReference serviceRef = si != null ? this.getDomain().registerService(refQName, handler, si) : this.getDomain().registerService(refQName, handler);
                Activation activation = new Activation(serviceRef, activator);
                activation.start();
                this._referenceBindings.add(activation);
            }
        }
    }

    private ServiceInterface getReferenceInterface(CompositeReferenceModel compositeRefModel) {
        ServiceInterface serviceInterface = null;
        if (this.hasCompositeReferenceInterface(compositeRefModel)) {
            serviceInterface = this.loadServiceInterface(compositeRefModel.getInterface());
        } else if (this.hasComponentReferenceInterface(compositeRefModel.getComponentReference())) {
            serviceInterface = this.loadServiceInterface((InterfaceModel)compositeRefModel.getComponentReference().getInterface());
        }
        return serviceInterface;
    }

    private boolean hasComponentReferenceInterface(ComponentReferenceModel componentRef) {
        return componentRef != null && componentRef.getInterface() != null;
    }

    private boolean hasCompositeReferenceInterface(CompositeReferenceModel compositeRef) {
        return compositeRef != null && compositeRef.getInterface() != null;
    }

    private ServiceInterface getComponentServiceInterface(ComponentServiceModel service) {
        ServiceInterface serviceInterface = null;
        if (service != null && service.getInterface() != null) {
            serviceInterface = this.loadServiceInterface((InterfaceModel)service.getInterface());
        }
        return serviceInterface;
    }

    private ServiceInterface loadServiceInterface(InterfaceModel intfModel) {
        WSDLService serviceInterface = null;
        if (intfModel != null) {
            if (this.isJavaInterface(intfModel.getType())) {
                String interfaceClass = intfModel.getInterface();
                Class<?> serviceInterfaceType = this.loadClass(interfaceClass);
                if (serviceInterfaceType == null) {
                    throw new SwitchYardException("Failed to load Service interface class '" + interfaceClass + "'.");
                }
                serviceInterface = JavaService.fromClass(serviceInterfaceType);
            } else if (intfModel.getType().equals(WSDL_INTERFACE)) {
                try {
                    serviceInterface = WSDLService.fromWSDL((String)intfModel.getInterface());
                }
                catch (WSDLReaderException wsdlre) {
                    throw new SwitchYardException((Throwable)wsdlre);
                }
            }
        }
        return serviceInterface;
    }

    private boolean isJavaInterface(String type) {
        return type.equals(JAVA_INTERFACE);
    }

    private void deployServices() {
        _log.debug((Object)("Deploying services for deployment " + this.getName()));
        HashMap<ComponentServiceModel, CompositeServiceModel> servicePromotions = new HashMap<ComponentServiceModel, CompositeServiceModel>();
        for (CompositeServiceModel compositeService : this.getConfig().getComposite().getServices()) {
            ComponentServiceModel componentService = compositeService.getComponentService();
            if (componentService == null) continue;
            servicePromotions.put(componentService, compositeService);
        }
        for (ComponentModel component : this.getConfig().getComposite().getComponents()) {
            Activator activator = this.findActivator(component);
            if (activator == null) {
                throw new SwitchYardException("Activator not found for " + component.getImplementation().getType());
            }
            for (ComponentServiceModel service : component.getServices()) {
                _log.debug((Object)("Registering service " + service.getQName() + " for component " + component.getImplementation().getType() + " for deployment " + this.getName()));
                ExchangeHandler handler = activator.init(service.getQName(), (Model)service);
                ServiceInterface serviceIntf = this.getComponentServiceInterface(service);
                ServiceReference serviceRef = serviceIntf != null ? this.getDomain().registerService(service.getQName(), handler, serviceIntf) : this.getDomain().registerService(service.getQName(), handler);
                CompositeServiceModel promotion = (CompositeServiceModel)servicePromotions.get(service);
                if (promotion != null && !promotion.getQName().equals(service.getQName())) {
                    if (serviceIntf != null) {
                        this.getDomain().registerService(promotion.getQName(), handler, serviceIntf);
                    } else {
                        this.getDomain().registerService(promotion.getQName(), handler);
                    }
                }
                Activation activation = new Activation(serviceRef, activator);
                activation.start();
                this._services.add(activation);
                this.fireComponentDeployed(component);
            }
        }
    }

    private void deployReferences() {
        _log.debug((Object)("Deploying references for deployment " + this.getName()));
        for (ComponentModel component : this.getConfig().getComposite().getComponents()) {
            Activator activator = this.findActivator(component);
            for (ComponentReferenceModel reference : component.getReferences()) {
                _log.debug((Object)("Registering reference " + reference.getQName() + " for component " + component.getImplementation().getType() + " for deployment " + this.getName()));
                ServiceReference service = this.getDomain().getService(reference.getQName());
                if (service == null) {
                    throw new SwitchYardException("Unable to activate reference, service not found: " + reference.getQName());
                }
                activator.init(reference.getQName(), (Model)reference);
                Activation activation = new Activation(service, activator);
                activation.start();
                this._references.add(activation);
            }
        }
    }

    private void deployServiceBindings() {
        _log.debug((Object)("Deploying service bindings for deployment " + this.getName()));
        for (CompositeServiceModel service : this.getConfig().getComposite().getServices()) {
            for (BindingModel binding : service.getBindings()) {
                _log.debug((Object)("Deploying binding " + binding.getType() + " for service " + service.getQName() + " for deployment " + this.getName()));
                Activator activator = this.findActivator(binding.getType());
                ServiceReference serviceRef = this.getDomain().getService(service.getQName());
                if (serviceRef == null) {
                    throw new SwitchYardException("Unable to activate binding, service not found: " + service.getQName());
                }
                activator.init(serviceRef.getName(), (Model)service);
                Activation activation = new Activation(serviceRef, activator);
                activation.start();
                this._serviceBindings.add(activation);
            }
            this.fireServiceDeployed(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployServiceBindings() {
        _log.debug((Object)("Undeploying reference bindings for deployment " + this.getName()));
        LinkedHashSet<QName> undeployedServiceNames = new LinkedHashSet<QName>();
        try {
            for (Activation activation : this._serviceBindings) {
                activation.stop();
                activation.destroy();
                undeployedServiceNames.add(activation.getService().getName());
            }
        }
        finally {
            this._serviceBindings.clear();
        }
        for (QName serviceName : undeployedServiceNames) {
            this.fireServiceUndeployed(serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployServices() {
        _log.debug((Object)("Undeploying services for deployment " + this.getName()));
        LinkedHashSet undeployedServiceNames = new LinkedHashSet();
        try {
            for (Activation activation : this._services) {
                activation.stop();
                activation.destroy();
            }
        }
        finally {
            this._services.clear();
        }
        for (QName serviceName : undeployedServiceNames) {
            this.fireComponentUndeployed(serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployReferences() {
        _log.debug((Object)("Undeploying references for deployment " + this.getName()));
        try {
            for (Activation activation : this._references) {
                activation.stop();
                activation.destroy();
            }
        }
        finally {
            this._references.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployReferenceBindings() {
        _log.debug((Object)("Undeploying reference bindings for deployment " + this.getName()));
        try {
            for (Activation activation : this._referenceBindings) {
                activation.stop();
                activation.destroy();
            }
        }
        finally {
            this._referenceBindings.clear();
        }
    }

    private void deployAutoRegisteredTransformers() {
        this.deployAutoRegisteredTransformers(this._services);
        this.deployAutoRegisteredTransformers(this._references);
    }

    private void deployAutoRegisteredTransformers(List<Activation> activationList) {
        for (Activation activation : activationList) {
            ServiceInterface serviceInterface = activation.getService().getInterface();
            this.deployAutoRegisteredTransformers(serviceInterface);
        }
    }

    private void destroyDomain() {
    }

    private Class<?> loadClass(String className) {
        return Classes.forName((String)className, this.getClass());
    }
}

