/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.io.IOException;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.io.Serialization;

@Serialization.Strategy(access=Serialization.AccessType.FIELD, factory=ContextPropertyFactory.class)
public class ContextProperty
implements Property {
    private String _name;
    private Scope _scope;
    private Object _value;

    private ContextProperty() {
    }

    ContextProperty(String name, Scope scope, Object value) {
        if (name == null || scope == null) {
            throw new IllegalArgumentException("Property name and scope must not be null!");
        }
        this._name = name;
        this._scope = scope;
        this._value = value;
    }

    public String getName() {
        return this._name;
    }

    public Scope getScope() {
        return this._scope;
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ContextProperty)) {
            return false;
        }
        ContextProperty comp = (ContextProperty)obj;
        return this._name.equals(comp.getName()) && this._scope.equals((Object)comp.getScope()) && (this._value == null ? comp.getValue() == null : this._value.equals(comp.getValue()));
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this._name.hashCode();
        hash = hash * 31 + this._scope.hashCode();
        hash = hash * 31 + (this._value != null ? this._value.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "[name=" + this._name + ", scope=" + this._scope + ", value=" + this._value + "]";
    }

    public static final class ContextPropertyFactory
    implements Serialization.Factory<ContextProperty> {
        public ContextProperty create(Class<ContextProperty> type) throws IOException {
            return new ContextProperty();
        }
    }
}

