/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.io.Serialization;

@Serialization.Strategy(access=Serialization.AccessType.FIELD)
public class ScopedPropertyMap {
    private Map<Scope, Map<String, Property>> _props = new HashMap<Scope, Map<String, Property>>();

    public ScopedPropertyMap() {
        for (Scope scope : Scope.values()) {
            this._props.put(scope, new HashMap());
        }
    }

    public void put(Property property) {
        this._props.get(property.getScope()).put(property.getName(), property);
    }

    public Property get(Scope scope, String name) {
        return this._props.get(scope).get(name);
    }

    public Set<Property> get(Scope scope) {
        return new HashSet<Property>(this._props.get(scope).values());
    }

    public Set<Property> get() {
        HashSet<Property> allProps = new HashSet<Property>();
        for (Scope scope : this._props.keySet()) {
            allProps.addAll(this.get(scope));
        }
        return allProps;
    }

    public void remove(Property property) {
        this._props.get(property.getScope()).remove(property.getName());
    }

    public void clear(Scope scope) {
        this._props.get(scope).clear();
    }

    public void clear() {
        for (Map<String, Property> map : this._props.values()) {
            map.clear();
        }
    }

    public ScopedPropertyMap copy() {
        ScopedPropertyMap props = new ScopedPropertyMap();
        for (Map<String, Property> scopedMap : this._props.values()) {
            for (Property prop : scopedMap.values()) {
                props.put(prop);
            }
        }
        return props;
    }
}

