/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.switchyard.common.io.CountingOutputStream;
import org.switchyard.internal.io.BaseSerializer;
import org.switchyard.internal.io.Serializer;

public final class GZIPSerializer
extends BaseSerializer {
    private final Serializer _serializer;

    public GZIPSerializer(Serializer serializer) {
        this._serializer = serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int serialize(T obj, Class<T> type, OutputStream out, int bufferSize) throws IOException {
        out = new CountingOutputStream(out);
        GZIPOutputStream gzip = new GZIPOutputStream(out, bufferSize);
        try {
            this._serializer.serialize(obj, type, gzip, bufferSize);
            gzip.finish();
            gzip.flush();
        }
        finally {
            if (this.isCloseEnabled()) {
                gzip.close();
            }
        }
        return ((CountingOutputStream)out).getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(InputStream in, Class<T> type, int bufferSize) throws IOException {
        in = new GZIPInputStream(in, bufferSize);
        try {
            T t = this._serializer.deserialize(in, type, bufferSize);
            return t;
        }
        finally {
            if (this.isCloseEnabled()) {
                in.close();
            }
        }
    }
}

