/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.switchyard.common.io.CountingOutputStream;
import org.switchyard.internal.io.BaseSerializer;

public final class ObjectStreamSerializer
extends BaseSerializer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int serialize(T obj, Class<T> type, OutputStream out, int bufferSize) throws IOException {
        out = new CountingOutputStream((OutputStream)new BufferedOutputStream(out, bufferSize));
        try {
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(obj);
            oos.flush();
        }
        finally {
            if (this.isCloseEnabled()) {
                out.close();
            }
        }
        return ((CountingOutputStream)out).getCount();
    }

    @Override
    public <T> T deserialize(InputStream in, Class<T> type, int bufferSize) throws IOException {
        in = new BufferedInputStream(in, bufferSize);
        try {
            ObjectInputStream ois = new ObjectInputStream(in);
            Object obj = ois.readObject();
            T t = type.cast(obj);
            return t;
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        finally {
            if (this.isCloseEnabled()) {
                in.close();
            }
        }
    }
}

