/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.io.graph;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.activation.DataSource;
import org.switchyard.internal.io.graph.Graph;
import org.switchyard.internal.io.graph.InputStreamGraph;

public class DataSourceGraph
implements Graph<DataSource> {
    private String _name;
    private String _contentType;
    private InputStreamGraph _inputStreamGraph;

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getContentType() {
        return this._contentType;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
    }

    public InputStreamGraph getInputStreamGraph() {
        return this._inputStreamGraph;
    }

    public void setInputStreamGraph(InputStreamGraph inputStreamGraph) {
        this._inputStreamGraph = inputStreamGraph;
    }

    @Override
    public void compose(DataSource object, Map<Integer, Object> visited) throws IOException {
        this.setName(object.getName());
        this.setContentType(object.getContentType());
        InputStreamGraph isg = new InputStreamGraph();
        isg.compose(object.getInputStream(), visited);
        this.setInputStreamGraph(isg);
    }

    @Override
    public DataSource decompose(Map<Integer, Object> visited) throws IOException {
        return new GraphDataSource(this);
    }

    public String toString() {
        return "DataSourceGraph(name=" + this.getName() + ", contentType=" + this.getContentType() + ", inputStreamGraph=" + this.getInputStreamGraph() + ")";
    }

    private static final class GraphDataSource
    implements DataSource {
        private DataSourceGraph _graph;

        public GraphDataSource(DataSourceGraph graph) {
            this._graph = graph;
        }

        public String getName() {
            return this._graph.getName();
        }

        public String getContentType() {
            return this._graph.getContentType();
        }

        public InputStream getInputStream() throws IOException {
            return this._graph.getInputStreamGraph().decompose((Map)null);
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

