/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.io.graph;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.switchyard.internal.io.graph.Graph;
import org.switchyard.internal.io.graph.GraphBuilder;

public class MapGraph<K, V>
implements Graph<Map<K, V>> {
    private LinkedHashMap<Graph<K>, Graph<V>> _map;

    public LinkedHashMap<Graph<K>, Graph<V>> getMap() {
        return this._map;
    }

    public void setMap(LinkedHashMap<Graph<K>, Graph<V>> map) {
        this._map = map;
    }

    @Override
    public void compose(Map<K, V> object, Map<Integer, Object> visited) throws IOException {
        this._map = new LinkedHashMap();
        for (Map.Entry<K, V> entry : object.entrySet()) {
            Graph<K> key = GraphBuilder.build(entry.getKey(), visited);
            Graph<V> value = GraphBuilder.build(entry.getValue(), visited);
            this._map.put(key, value);
        }
    }

    @Override
    public Map<K, V> decompose(Map<Integer, Object> visited) throws IOException {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (Map.Entry<Graph<K>, Graph<V>> entry : this.getMap().entrySet()) {
            map.put(entry.getKey().decompose(visited), entry.getValue().decompose(visited));
        }
        return map;
    }

    public String toString() {
        return "MapGraph(map=" + this.getMap() + ")";
    }
}

