/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.flatfile.variablefield;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.milyn.flatfile.Field;
import org.milyn.flatfile.FieldMetaData;
import org.milyn.flatfile.Record;
import org.milyn.flatfile.RecordMetaData;
import org.milyn.flatfile.RecordParser;
import org.milyn.flatfile.variablefield.VariableFieldRecordParserFactory;
import org.milyn.function.StringFunctionExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VariableFieldRecordParser<T extends VariableFieldRecordParserFactory>
implements RecordParser<T> {
    private T factory;
    private int recordCount = 0;

    public abstract List<String> nextRecordFieldValues() throws IOException;

    @Override
    public final void setRecordParserFactory(T factory) {
        this.factory = factory;
    }

    public T getFactory() {
        return this.factory;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Record nextRecord() throws IOException {
        List<String> fieldValues = this.nextRecordFieldValues();
        if (fieldValues == null || fieldValues.isEmpty()) {
            return null;
        }
        RecordMetaData recordMetaData = ((VariableFieldRecordParserFactory)this.factory).getRecordMetaData(fieldValues);
        ArrayList<Field> fields = new ArrayList<Field>();
        try {
            if (recordMetaData == VariableFieldRecordParserFactory.unknownVRecordType) {
                fields.add(new Field(recordMetaData.getFields().get(0).getName(), fieldValues.get(0)));
                Record record = new Record(recordMetaData.getName(), fields, recordMetaData);
                return record;
            }
            List<FieldMetaData> fieldsMetaData = recordMetaData.getFields();
            int fieldValueOffset = 0;
            if (((VariableFieldRecordParserFactory)this.factory).isMultiTypeRecordSet()) {
                fieldValueOffset = 1;
            }
            for (int i = 0; i < fieldValues.size(); ++i) {
                Field field;
                int fieldValueIndex = i + fieldValueOffset;
                if (fieldValueIndex > fieldValues.size() - 1) {
                    break;
                }
                if (!recordMetaData.isWildCardRecord() && i > fieldsMetaData.size() - 1) {
                    break;
                }
                String value = fieldValues.get(fieldValueIndex);
                if (recordMetaData.isWildCardRecord() || i > fieldsMetaData.size()) {
                    field = new Field("field_" + i, value);
                } else {
                    FieldMetaData fieldMetaData = fieldsMetaData.get(i);
                    if (fieldMetaData.ignore()) {
                        if ((i += fieldMetaData.getIgnoreCount() - 1) >= 0) continue;
                        i = 0x7FFFFFFE;
                        continue;
                    }
                    StringFunctionExecutor stringFunction = fieldMetaData.getStringFunctionExecutor();
                    if (stringFunction != null) {
                        value = stringFunction.execute(value);
                    }
                    field = new Field(fieldMetaData.getName(), value);
                    field.setMetaData(fieldMetaData);
                }
                fields.add(field);
            }
        }
        finally {
            ++this.recordCount;
        }
        return new Record(recordMetaData.getName(), fields, recordMetaData);
    }

    public int getUnignoredFieldCount(RecordMetaData recordMetaData) {
        if (((VariableFieldRecordParserFactory)this.factory).isMultiTypeRecordSet()) {
            return recordMetaData.getUnignoredFieldCount() + 1;
        }
        return recordMetaData.getUnignoredFieldCount();
    }
}

